package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MicroModifyarchivesRes;
import lombok.Data;

/**
 * 小微商户 修改结算银行卡
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=21_2
 */
@Data
public class MicroModifyarchivesReq implements WxPayReq<MicroModifyarchivesRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/applyment/micro/modifyarchives";
    }

    /**
     * 接口版本号 [是] 默认值1.0
     */
    private String version = "1.0";

    /**
     * 商户号 [是] 服务商的商户号
     */
    private String mch_id;

    /**
     * 随机字符串 [是] 参考签名规则
     */
    private String nonce_str;

    /**
     * 签名类型 [是] 签名类型，仅支持HMAC-SHA256。该字段需参与签名sign的计算。
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 小微商户号 [是] 小微商户的商户号
     */
    private String sub_mch_id;

    /**
     * 银行卡号 [否] 商户结算银行卡号,该字段属于敏感字段，需要进行加密处理，加密方法详见敏感信息加密说明
     */
    private String account_number;

    /**
     * 开户银行全称（含支行） [否]
     * 1）17家直连银行无需填写，其他银行请务必填写
     * 2）需填写银行全称，如"深圳农村商业银行XXX支行"
     * 详细参见开户银行全称（含支行）对照表
     */
    private String bank_name;

    /**
     * 开户银行 [否] 详细参见开户银行对照表
     */
    private String account_bank;

    /**
     * 开户银行省市编码 [是] 至少精确到市,详细参见微信支付提供省市对照表
     */
    private String bank_address_code;

    /**
     * 平台证书序列号 [是] 用于对敏感信息进行加密的平台证书序列号，获取方法详见平台证书及序列号获取接口（接口返回参数“serial_no”即为平台证书序列号）
     */
    private String cert_sn;

    /**
     * 返回值类型
     *
     * @return
     */
    @Override
    public Class getResClass() {
        return MicroModifyarchivesRes.class;
    }
}
