package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MicroQueryAutoWithDrawByDateRes;
import lombok.Data;

/**
 * 小微商户 查询提现状态
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=21_1
 */
@Data
public class MicroQueryAutoWithDrawByDateReq implements WxPayReq<MicroQueryAutoWithDrawByDateRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/fund/queryautowithdrawbydate";
    }

    /**
     * 商户号 [是] 微信支付分配的商户号
     */
    private String mch_id;

    /**
     * 小微商户号 [是] 微信支付分配的商户号
     */
    private String sub_mch_id;

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 签名类型 [是] 签名类型，目前支持HMAC-SHA256。该字段需参与签名sign的计算。
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 日期 [是] 格式：YYYYMMDD。要查询的提现单据的日期
     * 注意自动提现单是在交易次日汇总前一天的结算结果后生成，所以如果自动提现单日期是20180602，则对应的是20180601这天的交易。目前只支持查询最近30天的自动提现
     */
    private String date;

    /**
     * 随机字符串 [是] 随机字符串，不长于32位。推荐随机数生成算法
     */
    private String nonce_str;

    /**
     * 返回值类型
     *
     * @return
     */
    @Override
    public Class<MicroQueryAutoWithDrawByDateRes> getResClass() {
        return MicroQueryAutoWithDrawByDateRes.class;
    }
}
