package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MicropayRes;
import lombok.Data;

/**
 * 提交付款码支付
 * https://pay.weixin.qq.com/wiki/doc/api/micropay_sl.php?chapter=9_10&index=1
 */
@Data
public class MicropayReq implements WxPayReq<MicropayRes> {
    @Override
    public String getUrl(String channel) {
        return channel + "/pay/micropay";
    }

    /**
     * 服务商的APPID [是] 服务商商户的APPID
     */
    private String appid;

    /**
     * 子商户公众账号ID [否] 微信分配的子商户公众账号ID
     */
    private String sub_appid;

    /**
     * 商户号 [是] 微信支付分配的商户号
     */
    private String mch_id;

    /**
     * 子商户号 [是] 微信支付分配的子商户号，开发者模式下必填
     */
    private String sub_mch_id;

    /**
     * 设备号 [否] 终端设备号(商户自定义，如门店编号)
     */
    private String device_info;

    /**
     * 随机字符串 [是] 随机字符串，不长于32位。推荐随机数生成算法
     */
    private String nonce_str;

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 商品描述 [是] 商品或支付单简要描述，格式要求：门店品牌名-城市分店名-实际商品名称
     */
    private String body;

    /**
     * 商品详情 [否] 单品优惠功能字段，需要接入请见详细说明
     */
    private String detail;

    /**
     * 附加数据 [否] 附加数据，在查询API和支付通知中原样返回，该字段主要用于商户携带订单的自定义数据
     */
    private String attach;

    /**
     * 商户订单号 [是] 商户系统内部订单号，要求32个字符内，只能是数字、大小写字母_-|*且在同一个商户号下唯一。详见商户订单号
     */
    private String out_trade_no;

    /**
     * 总金额 [是] 订单总金额，单位为分，只能为整数，详见支付金额
     */
    private String total_fee;

    /**
     * 货币类型 [否] 符合ISO 4217标准的三位字母代码，默认人民币：CNY，其他值列表详见货币类型
     */
    private String fee_type;

    /**
     * 终端IP [是] 支持IPV4和IPV6两种格式的IP地址。调用微信支付API的机器IP
     */
    private String spbill_create_ip;

    /**
     * 订单优惠标记 [否] 订单优惠标记，代金券或立减优惠功能的参数，说明详见代金券或立减优惠
     */
    private String goods_tag;

    /**
     * 指定支付方式 [否] no_credit--指定不能使用信用卡支付
     */
    private String limit_pay;

    /**
     * 交易起始时间 [否] 订单生成时间，格式为yyyyMMddHHmmss，如2009年12月25日9点10分10秒表示为20091225091010。其他详见时间规则
     */
    private String time_start;

    /**
     * 交易结束时间 [否] 订单失效时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。注意：最短失效时间间隔需大于1分钟
     */
    private String time_expire;

    /**
     * 授权码 [是] 扫码支付授权码，设备读取用户微信中的条码或者二维码信息
     * （注：用户付款码条形码规则：18位纯数字，以10、11、12、13、14、15开头）
     */
    private String auth_code;

    /**
     * 电子发票入口开放标识 [否] Y，传入Y时，支付成功消息和支付详情页将出现开票入口。需要在微信支付商户平台或微信公众平台开通电子发票功能，传此字段才可生效
     */
    private String receipt;

    /**
     * 场景信息 [否] 该字段用于上报场景信息，目前支持上报实际门店信息。该字段为JSON对象数据，对象格式为{"store_info":{"id": "门店ID","name": "名称","area_code": "编码","address": "地址" }} ，字段详细说明请点击行前的+展开
     */
    private String scene_info;

    /**
     * 场景信息
     */
    @Data
    public static class SceneInfo {

        /**
         * 门店id 门店唯一标识
         */
        private String id;

        /**
         * 门店名称 门店名称
         */
        private String name;

        /**
         * 门店行政区划码 门店所在地行政区划码，详细见《最新县及县以上行政区划代码》
         */
        private String area_code;

        /**
         * 门店详细地址 门店详细地址
         */
        private String address;

    }

    @Override
    public Class<MicropayRes> getResClass() {
        return MicropayRes.class;
    }
}
