package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MultiprofitSharingRes;
import lombok.Data;

/**
 * 请求多次分账
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_6&index=2
 */
@Data
public class MultiprofitSharingReq implements WxPayReq<MultiprofitSharingRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/pay/multiprofitsharing";
    }

    /**
     * 小程序ID [是]
     */
    private String appid;

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户公众账号ID [否] 服务商下使用
     */
    private String sub_appid;

    /**
     * 子商户号 [是]  服务商下使用
     */
    private String sub_mch_id;


    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;

    /**
     * 签名类型 [否]
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 商户分账单号 [是]
     */
    private String out_order_no;

    /**
     * 微信订单号 [是]
     */
    private String transaction_id;

    /**
     * 分账接收方列表 [是]
     */
    private String receivers;

    @Override
    public Class<MultiprofitSharingRes> getResClass() {
        return MultiprofitSharingRes.class;
    }
}
