package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ProfitSharingFinishRes;
import lombok.Data;

/**
 * 完结分账
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_5&index=6
 */
@Data
public class ProfitSharingFinishReq implements WxPayReq<ProfitSharingFinishRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/pay/profitsharingfinish";
    }

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 微信支付分配的子商户号 [是]
     */
    private String sub_mch_id;

    /**
     * 公众账号ID [是]
     */
    private String appid;

    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign ;

    /**
     * 签名类型 [否]
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 微信订单号 [是]
     */
    private String transaction_id;

    /**
     * 商户分账单号 [是]
     */
    private String out_order_no;


    /**
     * 分账完结描述 [是]
     */
    private String description;

    @Override
    public Class<ProfitSharingFinishRes> getResClass() {
        return ProfitSharingFinishRes.class;
    }
}
