package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ProfitSharingQueryRes;
import lombok.Data;

/**
 * 查询分账结果
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_2&index=3
 */
@Data
public class ProfitSharingQueryReq implements WxPayReq<ProfitSharingQueryRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/pay/profitsharingquery";
    }

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户号 [是]  服务商下使用
     */
    private String sub_mch_id;

    /**
     * 微信订单号 [是]
     */
    private String transaction_id;

    /**
     * 商户订单号 [是]
     */
    private String out_trade_no;

    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;

    /**
     * 签名类型 [否]
     */
    private String sign_type = "HMAC-SHA256";

    @Override
    public Class<ProfitSharingQueryRes> getResClass() {
        return ProfitSharingQueryRes.class;
    }
}
