package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ProfitSharingRes;
import lombok.Data;

/**
 * 请求单次分账
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_1&index=1
 */
@Data
public class ProfitSharingReq implements WxPayReq<ProfitSharingRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/pay/profitsharing";
    }

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户号 [是]  服务商下使用
     */
    private String sub_mch_id;

    /**
     * 小程序ID [是]
     */
    private String appid;

    /**
     * 子商户公众账号ID [否] 服务商下使用
     */
    private String sub_appid;

    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;

    /**
     * 签名类型 [否]
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 商户订单号 [是]
     */
    private String out_order_no;

    /**
     * 微信订单号 [是]
     */
    private String transaction_id;

    /**
     * 分账接收方列表 [是]
     */
    private String receivers;

    @Override
    public Class<ProfitSharingRes> getResClass() {
        return ProfitSharingRes.class;
    }
}
