package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ProfitSharingReturnQueryRes;
import lombok.Data;

/**
 * 回退结果查询
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_8&index=8
 */
@Data
public class ProfitSharingReturnQueryReq implements WxPayReq<ProfitSharingReturnQueryRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/pay/profitsharingreturnquery";
    }

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户号 [是]  服务商下使用
     */
    private String sub_mch_id;

    /**
     * 小程序ID [是]
     */
    private String appid;

    /**
     * 随机字符串 [是] 随机字符串，不长于32位。推荐随机数生成算法
     */
    private String nonce_str;

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 签名类型 [否] 签名类型，目前只支持HMAC-SHA256
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 微信分账单号 [否] 原发起分账请求时，微信返回的微信分账单号，与商户分账单号一一对应。
     * 微信分账单号与商户分账单号二选一填写
     */
    private String order_id;

    /**
     * 商户分账单号 [否] 原发起分账请求时使用的商户后台系统的分账单号。
     * 微信分账单号与商户分账单号二选一填写
     */
    private String out_order_no;

    /**
     * 商户回退单号 [是] 此回退单号是商户在自己后台生成的一个新的回退单号，在商户后台唯一
     * 只能是数字、大小写字母_-|*@ ，同一回退单号多次请求等同一次。
     */
    private String out_return_no;

    /**
     * 返回值类型
     *
     * @return
     */
    @Override
    public Class getResClass() {
        return ProfitSharingReturnQueryRes.class;
    }
}
