package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ProfitSharingReturnRes;
import lombok.Data;

/**
 * 分账回退
 * https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_5
 */
@Data
public class ProfitSharingReturnReq implements WxPayReq<ProfitSharingReturnRes> {
    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/pay/profitsharingreturn";
    }

    /**
     * 商户号 [是] 微信支付分配的商户号
     */
    private String mch_id;

    /**
     * 子商户号 [是] 微信支付分配的子商户号
     */
    private String sub_mch_id;

    /**
     * 公众账号ID [否] 微信分配的子商户公众账号ID
     */
    private String sub_appid;

    /**
     * 随机字符串 [是] 随机字符串，不长于32位。推荐随机数生成算法
     */
    private String nonce_str;

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 签名类型 [否] 签名类型，目前只支持HMAC-SHA256
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 微信分账单号 [否] 原发起分账请求时，微信返回的微信分账单号，与商户分账单号一一对应。
     * 微信分账单号与商户分账单号二选一填写
     */
    private String order_id;

    /**
     * 商户分账单号 [否] 原发起分账请求时使用的商户后台系统的分账单号。
     * 微信分账单号与商户分账单号二选一填写
     */
    private String out_order_no;

    /**
     * 商户回退单号 [是] 此回退单号是商户在自己后台生成的一个新的回退单号，在商户后台唯一
     * 只能是数字、大小写字母_-|*@ ，同一回退单号多次请求等同一次。
     */
    private String out_return_no;

    /**
     * 回退方类型 [是] 枚举值：
     * MERCHANT_ID：商户ID
     * 暂时只支持从商户接收方回退分账金额
     */
    private String return_account_type;

    /**
     * 回退方账号 [是] 回退方类型是MERCHANT_ID时，填写商户ID
     * 只能对原分账请求中成功分给商户接收方进行回退
     */
    private String return_account;

    /**
     * 回退金额 [是] 需要从分账接收方回退的金额，单位为分，只能为整数，不能超过原始分账单分出给该接收方的金额
     */
    private String return_amount;

    /**
     * 回退描述 [是] 分账回退的原因描述
     */
    private String description;

    @Override
    public Class getResClass() {
        return ProfitSharingReturnRes.class;
    }
}
