package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.RefundQueryRes;
import lombok.Data;

/**
 * 查询退款
 * https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_5
 */
@Data
public class RefundQueryReq implements WxPayReq<RefundQueryRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/pay/refundquery";
    }

    /**
     * 小程序ID [是]
     */
    private String appid;

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户公众账号ID [否] 服务商下使用
     */
    private String sub_appid;

    /**
     * 子商户号 [是]  服务商下使用
     */
    private String sub_mch_id;


    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;


    /**
     * 签名类型 [是]
     */
    private String sign_type;

    /**
     * 微信订单号  transaction_id out_trade_no  out_refund_no refund_id 四选一
     */
    private String transaction_id;

    /**
     * 商户订单号  transaction_id out_trade_no  out_refund_no refund_id 四选一
     */
    private String out_trade_no;

    /**
     * 商户退款单号   transaction_id out_trade_no  out_refund_no refund_id 四选一
     */
    private String out_refund_no;

    /**
     * 微信退款单号   transaction_id out_trade_no  out_refund_no refund_id 四选一
     */
    private String refund_id;

    /**
     * 偏移量 [否]
     */
    private String offset;

    @Override
    public Class<RefundQueryRes> getResClass() {
        return RefundQueryRes.class;
    }
}
