package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.UnifiedOrderRes;
import lombok.Data;

/**
 * 微信统一下单请求参数
 * 接口地址: https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_1
 */
@Data
public class UnifiedOrderReq implements WxPayReq<UnifiedOrderRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/pay/unifiedorder";
    }

    /**
     * 子商户公众账号ID [否] 服务商下使用
     */
    private String sub_appid;

    /**
     * 子商户号 [是]  服务商下使用
     */
    private String sub_mch_id;

    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;


    /**
     * 微信appid [是]
     */
    private String appid;
    /**
     * 商户号 [是]
     */
    private String mch_id;
    /**
     * 设备号 [否]
     */
    private String device_info;

    /**
     * 签名类型 [否]
     */
    private String sign_type;

    /**
     * 商品描述[是]
     */
    private String body;
    /**
     * 商品详情[否]
     */
    private String detail;
    /**
     * 附件数据[否]
     */
    private String attach;
    /**
     * 商品订单号[是]
     */
    private String out_trade_no;
    /**
     * 货币币种[否]
     */
    private String fee_type;
    /**
     * 标价金额[是]
     */
    private String total_fee;
    /**
     * 终端IP[是]
     */
    private String spbill_create_ip;
    /**
     * 交易起始时间[否]
     */
    private String time_start;
    /**
     * 交易结束时间[否]
     */
    private String time_expire;
    /**
     * 订单优惠标记[否]
     */
    private String goods_tag;
    /**
     * 通知地址[是]
     */
    private String notify_url;
    /**
     * 交易类型[是]
     */
    private String trade_type;
    /**
     * 商品ID[否]
     */
    private String product_id;

    /**
     * 指定支付方式[否]
     */
    private String limit_pay;

    /**
     * 用户标识[否]
     */
    private String openid;


    /**
     * trade_type=JSAPI，此参数必传
     * 用户在子商户appid下的唯一标识
     */
    private String sub_openid;


    /**
     * 电子发票入口开放标识[否]
     */
    private String receipt;

    /**
     * 场景信息[否]
     */
    private String scene_info;


    /**
     * 是否指定服务商分账
     * <p>
     * Y-是，需要分账
     * N-否，不分账
     * 字母要求大写，不传默认不分账
     *
     * @return
     */
    private String profit_sharing;


    @Override
    public Class<UnifiedOrderRes> getResClass() {
        return UnifiedOrderRes.class;
    }
}
