package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * 小微查询申请状态
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=19_2
 */
@Data
@XmlRootElement(name="xml")
public class ApplymentMicroSubmitGetstateRes extends WxPayRes {

    /**
     * 随机字符串 随机字符串
     */
    private String nonce_str;

    /**
     * 签名 参考2.2签名规则
     */
    private String sign;

    /**
     * 业务结果 SUCCESS/FAIL
     */
    private String result_code;

    /**
     * 错误代码 参考业务错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 参考业务错误码列表
     */
    private String err_code_des;

    /**
     * 以下字段当return_code 、result_code都为SUCCESS时有返回
     */

    /**
     * 商户申请单号 微信支付分配的申请单号
     */
    private String applyment_id;

    /**
     * 申请状态
     * AUDITING:审核中
     * REJECTED:已驳回
     * FROZEN:已冻结
     * TO_BE_SIGNED:待签约
     * FINISH:完成
     */
    private String applyment_state;

    /**
     * 申请状态描述 申请状态描述
     */
    private String applyment_state_desc;

    /**
     * 小微商户号 当申请状态为TO_BE_SIGNED或FINISH时才返回
     */
    private String sub_mch_id;

    /**
     * 签约链接 当申请状态为TO_BE_SIGNED或FINISH时才返回
     */
    private String sign_url;

    /**
     * 审核详情 各项被驳回资料的驳回理由。当申请状态为REJECTED时才返回。字段值为json格式，字段详细说明见下拉列表（点击行前“+”打开下拉列表）
     */
    private String audit_detail;

//    /**
//     * 审核详情
//     */
//    @Data
//    @XmlRootElement(name="xml")
//    public static class AuditDetail {
//
//        /**
//         *
//         */
//        private String param_name;
//
//        /**
//         *
//         */
//        private String reject_reason;
//    }

}
