package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 查询升级申请单状态接口
 * https://pay.weixin.qq.com/wiki/doc/api/mch_xiaowei.php?chapter=28_3&index=3
 */
@Data
public class ApplymentMicroSubmitupgradeGetstateRes extends WxPayRes {

    /**
     * 随机字符串 随机字符串
     */
    private String nonce_str;

    /**
     * 签名 详见签名生成算法
     */
    private String sign;

    /**
     * 业务结果 SUCCESS/FAIL
     */
    private String result_code;

    /**
     * 错误代码 参考业务错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 参考业务错误码列表
     */
    private String err_code_des;

    /**
     * 以下字段当return_code 、result_code都为SUCCESS时有返回
     */

    /**
     * 小微商户号 小微商户的商户号
     */
    private String sub_mch_id;

    /**
     * 申请状态
     * CHECKING:资料校验中
     * ACCOUNT_NEED_VERIFY：待账户验证
     * AUDITING:审核中
     * REJECTED:已驳回
     * NEED_SIGN:待签约
     * FINISH:完成
     * FROZEN:已冻结
     */
    private String applyment_state;

    /**
     * 申请状态描述
     * UPGRADED:已升级
     * 已驳回
     */
    private String applyment_state_desc;

    /**
     * 签约二维码 当申请状态为NEED_SIGN或FINISH时才返回
     */
    private String sign_qrcode;

    /**
     * 签约链接 当申请状态为NEED_SIGN或FINISH时才返回
     */
    private String sign_url;

    /**
     * 审核详情 各项资料的审核情况。当申请状态为REJECTED或 FROZEN时才返回。字段值为json格式，详情参考2.2.5。
     */
    private String audit_detail;

    /**
     * 以下字段当 applyment_state 为ACCOUNT_NEED_VERIFY 时有返回，请商户按照以下信息进行汇款，以完成账户验证
     * 注：1、个体户、企业，无此账户验证环节；2、验证结束后，汇款金额将全额退还至汇款账户。
     */

    /**
     * 付款户名 需商户使用该户名的账户进行汇款
     */
    private String account_name;

    /**
     * 汇款金额 需要汇款的金额(单位 分)
     */
    private String pay_amount;

    /**
     * 收款卡号 收款账户的卡号
     */
    private String destination_account_number;

    /**
     * 收款户名 收款账户名
     */
    private String destination_account_name;

    /**
     * 开户银行 收款账户的开户银行名称
     */
    private String destination_account_bank;

    /**
     * 省市信息 收款账户的省市
     */
    private String city;

    /**
     * 备注信息 商户汇款时，需要填写的备注信息
     */
    private String remark;

    /**
     * 汇款截止时间 请在此时间前完成汇款
     */
    private String deadline_time;

    /**
     * 审核详情
     */
    @Data
    public static class AuditDetail {

        /**
         * 参数名称 与2.1.3对应
         */
        private String param_name;

        /**
         * 驳回原因
         */
        private String reject_reason;
    }

}
