package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 小微提交升级申请单接口
 * https://pay.weixin.qq.com/wiki/doc/api/mch_xiaowei.php?chapter=28_2&index=2
 */
@Data
public class ApplymentMicroSubmitupgradeRes extends WxPayRes {

    /**
     * 随机字符串 随机字符串
     */
    private String nonce_str;

    /**
     * 签名 参考2.2签名规则
     */
    private String sign;

    /**
     * 业务结果 SUCCESS/FAIL
     */
    private String result_code;

    /**
     * 错误代码 参考业务错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 参考业务错误码列表
     */
    private String err_code_des;

    /**
     * 参数校验不通过的字段名 当err_code为PARAM_ERROR时，返回有误的请求参数字段名。
     */
    private String err_param;

}
