package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * 微信获取平台证书
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=19_2
 */
@Data
@XmlRootElement(name = "xml")
public class GetcertficatesRes extends WxPayRes {

    /**
     * 商户号 调用接口提交的商户号
     */
    private String mch_id;

    /**
     * 随机字符串 微信返回的随机字符串
     */
    private String nonce_str;

    /**
     * 签名 微信返回的签名，详见签名生成算法
     */
    private String sign;

    /**
     * 业务结果
     * SUCCESS：支付成功
     * FAIL：根据err_code的指引决定下一步操作。
     */
    private String result_code;

    /**
     * 错误代码 详细参见错误列表
     */
    private String err_code;

    /**
     * 错误代码描述 错误返回的信息描述，详见收银员操作指引列表
     */
    private String err_code_des;

    /**
     * 当return_code 和result_code都为SUCCESS的时，还会包括以下字段
     */

    /**
     * 平台证书信息 包含了平台证书序列号serial_no、证书启用时间effective_time、证书弃用时间expire_time、加密证书信息包encrypt_certificate，请根据平台证书解密指引获取证书明文（证书明文为PEM格式），方可使用
     */
    private String certificates;

    /**
     * 证书信息
     */

    /**
     * 平台证书序列号
     */
    private String serial_no;

    /**
     * 证书启用时间
     */
    private String effective_time;

    /**
     * 证书弃用时间
     */
    private String expire_time;

    /**
     * 证书
     */
    private String cert;
}
