package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 小微商户 小微商户关注功能配置API
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=20_0&index=1
 */
@Data
public class MicroAddRecommendConfRes extends WxPayRes {

    /**
     * 以下字段在return_code为SUCCESS的时候有返回
     */

    /**
     * 业务结果 此字段是业务标识，表示业务是否成功。目前只有SUCCESS和FAIL两种
     */
    private String result_code;

    /**
     * 签名 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 错误代码 见错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 错误信息描述
     */
    private String err_code_des;
}
