package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 小微商户 修改联系信息
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=21_4
 */
@Data
public class MicroModifyContactInfoRes extends WxPayRes {

    /**
     * 当return_code为SUCCESS的时候，还会包括以下字段：
     */

    /**
     * 随机字符串 随机字符串
     */
    private String nonce_str;

    /**
     * 签名 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 业务结果 SUCCESS/FAIL
     */
    private String result_code;

    /**
     * 错误代码 参考业务错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 参考业务错误码列表
     */
    private String err_code_des;

    /**
     * 当return_code 和result_code都为SUCCESS的时，还会包括以下字段：
     */

    /**
     * 商户号 服务商的商户号
     */
    private String mch_id;

    /**
     * 小微商户号 小微商户的商户号
     */
    private String sub_mch_id;
}
