package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 小微商户 小微商户开发配置查询API
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=20_4&index=4
 */
@Data
public class MicroQuerySubDevConfigRes extends WxPayRes {

    /**
     * 以下字段在return_code为SUCCESS的时候有返回
     */

    /**
     * 业务结果 此字段是业务标识，表示业务是否成功。目前只有SUCCESS和FAIL两种
     */
    private String result_code;

    /**
     * 签名 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 错误代码 见错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 错误信息描述
     */
    private String err_code_des;

    /**
     * 授权目录 公众账号JS API支付授权目录列表 ，JSON格式数据，每个支付目录 要求符合URI格式规范，最多返回5个
     * { jsapi_path_list": [
     * "http://www.qq.com/abcd/",
     * "http://www.qq.com/abcdedfg/"
     * ] }
     */
    private String jsapi_path_list;

    /**
     * 关联APPID与关注 sub_appid为绑定好的商户公众号、小程序、APP支付等APPID；
     * subscribe_appid关注公众号的APPID；
     * 配置关系如果绑定多个以列表形式返回，如果不区分绑定则sub_appid=NULL的记录返回默认推荐关注的APPID
     * <p>
     * { "appid_config_list": [
     * { " subscribe_appid ": "wxa9d9651ae82ec4b9", "sub_appid": "null" },
     * { "subscribe_appid": "wxa9d9651ae82ec4b9", "sub_appid": "wxa9d9651ae82ec4b9" }
     * ] }
     */
    private String appid_config_list;
}
