package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 小微商户 重新发起提现
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=21_3
 */
@Data
public class MicroReautoWithDrawByDateRes extends WxPayRes {

    /**
     * 当return_code为SUCCESS时，进一步返回以下字段
     */

    /**
     *业务结果 此字段是业务标识，表示业务是否成功。目前只有SUCCESS和FAIL两种
     * SUCCESS: 接口调用成功。表示本次自动提现请求已经受理成功，请等待银行处理结果
     * FAIL：接口调用失败。请根据err_code决定具体错误类型
     */
    private String result_code;

    /**
     *错误代码 见错误码列表
     */
    private String err_code;

    /**
     *错误代码描述 错误代码描述
     */
    private String err_code_des;

    /**
     *签名类型 签名类型，目前支持HMAC-SHA256
     */
    private String sign_type;

    /**
     *签名 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 当return_code和result_code都为SUCCESS的时候，还会包含以下字段
     */

    /**
     *自动提现单提现日期 格式：YYYYMMDD。
     * 注意自动提现单是在交易次日汇总前一天的结算结果后生成，所以如果自动提现单日期是20180602，则对应的是20180601这天的交易。
     */
    private String date;

    /**
     *商户号 微信支付分配的商户号
     */
    private String mch_id;

    /**
     *小微商户号 微信支付分配的商户号
     */
    private String sub_mch_id;

    /**
     *提现单单据ID 如果成功创建提现单据，则表示提现单据的ID
     */
    private String withdraw_id;

    /**
     *金额 分（RMB）
     */
    private String amount;

    /**
     *单据创建时间 时间格式为YYYY-MM-ddHH:mm:ss
     */
    private String create_time;

    /**
     *随机字符 随机字符串(与请求一致)
     */
    private String nonce_str;
}
