package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 关闭订单接口
 * https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_3
 */
@Data
public class OrderCloseRes extends WxPayRes {

    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;


    /**
     * 小程序ID [是]
     */
    private String appid;

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 业务结果 SUCCESS/FAIL
     */
    private String result_code;

    /**
     * 业务结果描述
     */
    private String result_msg;

    /**
     * 错误代码
     */
    private String err_code;

    /**
     * 错误代码描述
     */
    private String err_code_des;


}
