package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 回退结果查询
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_8&index=8
 */
@Data
public class ProfitSharingReturnQueryRes extends WxPayRes {

    /**
     * 错误代码 如果返回状态码为FAIL，则本字段存在，且为失败的错误码
     * 详见错误码列表
     */
    private String error_code;

    /**
     * 返回信息 如果返回状态码为FAIL，则本字段存在，且为失败的错误信息
     */
    private String error_msg;

    /**
     * 以下字段在return_code为SUCCESS的时候有返回
     */

    /**
     * 商户号 调用接口时提供的商户号
     */
    private String mch_id;

    /**
     * 子商户号 微信支付分配特约商户的商户号
     */
    private String sub_mch_id;

    /**
     * 公众账号ID 调用接口提供的公众账号ID
     */
    private String appid;

    /**
     * 随机字符串 微信返回的随机字符串
     */
    private String nonce_str;

    /**
     * 签名 微信返回的签名，详见签名算法
     */
    private String sign;

    /**
     * 微信分账单号 原发起分账请求时，微信返回的微信分账单号
     */
    private String order_id;

    /**
     * 商户分账单号 原发起分账请求时使用的商户系统内部的分账单号。
     */
    private String out_order_no;

    /**
     * 商户回退单号 调用接口提供的商户系统内部的回退单号
     */
    private String out_return_no;

    /**
     * 微信回退单号 微信分账回退单号，微信系统返回的唯一标识
     */
    private String return_no;

    /**
     * 回退方类型 枚举值：
     * MERCHANT_ID：商户ID
     */
    private String return_account_type;

    /**
     * 回退方账号 回退方类型是MERCHANT_ID时，商户ID
     */
    private String return_account;

    /**
     * 回退金额 回退金额，整数，单位为分
     */
    private String return_amount;

    /**
     * 回退描述 分账回退的原因描述
     */
    private String description;

    /**
     * 回退结果 枚举值：
     * PROCESSING:处理中
     * SUCCESS:已成功
     * FAIL: 已失败
     * 如果返回为处理中，请勿变更商户回退单号，使用相同的参数再次发起分账回退，否则会出现资金风险
     * 在处理中状态的回退单如果5天没有成功，会因为超时被设置为已失败。
     */
    private String result;

    /**
     * 失败原因 枚举值：
     * ACCOUNT_ABNORMAL:分账接收方账户异常
     * TIME_OUT_CLOSED: 超时关单
     * 此字段仅回退结果为FAIL时存在
     */
    private String fail_reason;

    /**
     * 完成时间 分账回退完成时间
     */
    private String finish_time;
}
