package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 撤销订单
 * https://pay.weixin.qq.com/wiki/doc/api/micropay.php?chapter=9_11&index=3
 */
@Data
public class ReverseRes extends WxPayRes {

    /**
     * 公众账号ID 返回提交的公众账号ID
     */
    private String appid;

    /**
     * 商户号 返回提交的商户号
     */
    private String mch_id;

    /**
     * 随机字符串 微信返回的随机字符串
     */
    private String nonce_str;

    /**
     * 签名 返回数据的签名，详见签名算法
     */
    private String sign;

    /**
     * 业务结果 SUCCESS/FAIL
     */
    private String result_code;

    /**
     * 错误代码 详细参见错误列表
     */
    private String err_code;

    /**
     * 错误描述 结果信息描述
     */
    private String err_code_des;

    /**
     * 是否重调 是否需要继续调用撤销，Y-需要，N-不需要
     */
    private String recall;
}
