package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 微信统一下单请求参数
 * 接口地址: https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_sl_api.php?chapter=9_1
 */
@Data
public class UnifiedOrderRes extends WxPayRes {

    /**
     * 服务商的APPID 服务商商户的APPID
     */
    private String appid;

    /**
     * 商户号 调用接口提交的商户号
     */
    private String mch_id;

    /**
     * 小程序的APPID 微信分配的小程序ID
     */
    private String sub_appid;

    /**
     * 子商户号 微信支付分配的子商户号
     */
    private String sub_mch_id;

    /**
     * 设备号 调用接口提交的终端设备号
     */
    private String device_info;

    /**
     * 随机字符串 微信返回的随机字符串
     */
    private String nonce_str;

    /**
     * 签名 微信返回的签名，详见签名算法
     */
    private String sign;

    /**
     * 业务结果 SUCCESS/FAIL
     */
    private String result_code;

    /**
     * 错误代码 详细参见第6节错误列表
     */
    private String err_code;

    /**
     * 错误代码描述 错误返回的信息描述
     */
    private String err_code_des;

    /**
     * 交易类型 调用接口提交的交易类型，取值如下：JSAPI，详细说明见参数规定
     */
    private String trade_type;

    /**
     * 预支付交易会话标识 微信生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    private String prepay_id;

    /**
     * 二维码链接 trade_type=NATIVE时有返回，此url用于生成支付二维码，然后提供给用户进行扫码支付。
     * 注意：code_url的值并非固定，使用时按照URL格式转成二维码即可
     */
    private String code_url;

}
