package com.jhscale.wxpay.utils;

import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.util.Base64;

/**
 * @author lie_w
 * @title: AesGcmExample2
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2019/11/623:56
 */
public class AesGcmExample2 {

    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int NONCE_LENGTH_BYTE = 12;
    public static final String AES_KEY = "PAY9926wxAPIfromNGFFatJHSCALEcom"; // APIv3密钥
    private static final String TRANSFORMATION_PKCS1Padding = "RSA/ECB/PKCS1Padding";

    /**
     * @Description APIv3密钥 解密
     * @Author wanglie
     * @Date 2:22 2019/4/11
     **/
    public static String aesgcmDecrypt(String v3key, String associatedData, String nonce, String cipherText) throws Exception {
        final Cipher cipher = Cipher.getInstance(ALGORITHM, "SunJCE");
        SecretKeySpec key = new SecretKeySpec(v3key.getBytes(), "AES");
        GCMParameterSpec spec = new GCMParameterSpec(TAG_LENGTH_BIT, nonce.getBytes());
        cipher.init(Cipher.DECRYPT_MODE, key, spec);
        cipher.updateAAD(associatedData.getBytes());
        return new String(cipher.doFinal(Base64.getDecoder().decode(cipherText)));
    }
}
