package com.jhscale.wxpay.utils;

import ch.qos.logback.core.encoder.ByteArrayUtil;
import org.springframework.util.DigestUtils;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/**
 * @author lie_w
 * @title: Signature
 * @projectName rely-on-pay
 * @description: TODO
 * @date 2019/11/211:33
 */
public class Signature {
    /**
     * @description: 签名给算法
     **/
    public static String getSign(Map<String, Object> map, String key) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() != "") {
                list.add(entry.getKey() + "=" + entry.getValue() + "&");
            }
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; i++) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result += "key=" + key;
        result = ByteArrayUtil.toHexString(DigestUtils.md5Digest(result.getBytes(Charset.forName("utf8")))).toUpperCase();

        return result;
//        return HmacSHA256Encode(result, key);

    }

    private static String HmacSHA256Encode(String str, String key) {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] bytes = sha256_HMAC.doFinal(str.getBytes());
            return ByteArrayUtil.toHexString(bytes).toUpperCase();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
