/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.quartz.handle;

import com.jhscale.quartz.mapper.TJobDetailMapper;
import com.jhscale.quartz.pojo.TJobDetail;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.framework.utils.EntityUtils;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractJob.class);
    @Autowired
    private TJobDetailMapper jobDetailMapper;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TriggerKey key = context.getTrigger().getKey();
        TJobDetail jobDetail = new TJobDetail();
        EntityUtils.init((Object)jobDetail);
        jobDetail.setExecuteStarttime(new Date());
        jobDetail.setJobId(Integer.parseInt(key.getName()));
        try {
            this.run(context);
            jobDetail.setExecuteState("0");
        }
        catch (Exception e) {
            jobDetail.setExecuteState("1");
            String name = key.getClass().getCanonicalName();
            String exp = name.substring(name.lastIndexOf(".") + 1);
            log.error(exp + "\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
            jobDetail.setExecuteRemark(exp + " " + e.getMessage());
        }
        jobDetail.setExecuteEndtime(new Date());
        this.jobDetailMapper.insert(jobDetail);
    }

    public abstract void run(JobExecutionContext var1) throws CommonException;
}

