/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.quartz.init;

import com.jhscale.quartz.pojo.TJobInfo;
import com.jhscale.quartz.service.MJobService;
import com.jhscale.quartz.service.MTaskService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class JobInitDetector
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(JobInitDetector.class);
    @Autowired
    private MJobService jobService;
    @Autowired
    private MTaskService taskService;

    public void run(String ... args) throws Exception {
        log.info("init quartz job ...");
        List<TJobInfo> jobInfos = this.jobService.getNeedStartJob();
        if (jobInfos != null && !jobInfos.isEmpty()) {
            log.info("quartz size {}", (Object)jobInfos.size());
            for (TJobInfo jobInfo : jobInfos) {
                if (this.taskService.checkJob(jobInfo)) continue;
                this.taskService.startJob(jobInfo);
            }
        } else {
            log.info("quartz size {0}");
        }
        log.info("init quartz job success.");
    }
}

