/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.quartz.service.impl;

import com.github.pagehelper.PageHelper;
import com.jhscale.quartz.entity.JobDetailPageRes;
import com.jhscale.quartz.entity.JobDetailVo;
import com.jhscale.quartz.entity.JobInfoPageRes;
import com.jhscale.quartz.entity.JobPageQuery;
import com.jhscale.quartz.mapper.JobMapper;
import com.jhscale.quartz.mapper.TJobDetailMapper;
import com.jhscale.quartz.mapper.TJobInfoMapper;
import com.jhscale.quartz.pojo.TJobDetail;
import com.jhscale.quartz.pojo.TJobDetailExample;
import com.jhscale.quartz.pojo.TJobInfo;
import com.jhscale.quartz.pojo.TJobInfoExample;
import com.jhscale.quartz.service.MJobService;
import com.ysscale.framework.em.DataStateEnum;
import com.ysscale.framework.model.page.Page;
import com.ysscale.framework.utils.DateUtils;
import com.ysscale.mybatis.util.PackageMySQLPageInfo;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MJobServiceImpl
implements MJobService {
    @Autowired
    private TJobInfoMapper jobInfoMapper;
    @Autowired
    private TJobDetailMapper jobDetailMapper;
    @Autowired
    private JobMapper jobMapper;

    @Override
    public Page<JobInfoPageRes> getJobPage(JobPageQuery pageQuery) {
        PageHelper.startPage((int)pageQuery.getPage(), (int)pageQuery.getLimit());
        List<JobInfoPageRes> list = this.jobMapper.getJobPage(pageQuery);
        return PackageMySQLPageInfo.packageInfo(list);
    }

    @Override
    public Boolean add(TJobInfo tJobInfo) {
        return this.jobInfoMapper.insert(tJobInfo) > 0;
    }

    @Override
    public TJobInfo getJobInfoById(Integer id) {
        return this.jobInfoMapper.selectByPrimaryKey(id);
    }

    @Override
    public Boolean updateJobInfoById(TJobInfo tJobInfo) {
        return this.jobInfoMapper.updateByPrimaryKeySelective(tJobInfo) > 0;
    }

    @Override
    public Page<JobDetailPageRes> showJobDetail(JobPageQuery pageQuery) {
        if (Objects.isNull(pageQuery.getId())) {
            return new Page();
        }
        PageHelper.startPage((int)pageQuery.getPage(), (int)pageQuery.getLimit());
        TJobDetailExample example = new TJobDetailExample();
        if (StringUtils.isNotBlank((String)pageQuery.getOrder())) {
            example.setOrderByClause(pageQuery.getOrder());
        } else {
            example.setOrderByClause("execute_starttime desc");
        }
        example.createCriteria().andJobIdEqualTo(pageQuery.getId()).andStateEqualTo("0");
        List<TJobDetail> list = this.jobDetailMapper.selectByExample(example);
        return PackageMySQLPageInfo.packageInfo(list, JobDetailPageRes.class);
    }

    @Override
    public Boolean clearJobDetail(JobDetailVo jobDetail) {
        TJobDetailExample example = new TJobDetailExample();
        TJobDetailExample.Criteria criteria = example.createCriteria();
        if (jobDetail.isClearAll()) {
            if (Objects.nonNull(jobDetail.getId())) {
                criteria.andJobIdEqualTo(jobDetail.getId());
            } else {
                criteria.andIdGreaterThan(0);
            }
        } else {
            if (Objects.nonNull(jobDetail.getId())) {
                criteria.andJobIdEqualTo(jobDetail.getId());
            }
            if (Objects.nonNull(jobDetail.getClearTime())) {
                criteria.andExecuteStarttimeLessThan(jobDetail.getClearTime());
            }
            if (Objects.nonNull(jobDetail.getDay())) {
                Date clearTime = DateUtils.addDate((Date)DateUtils.getCurrertDate((Date)new Date()), (int)(0 - jobDetail.getDay()));
                criteria.andExecuteStarttimeLessThan(clearTime);
            }
            if (StringUtils.isNotBlank((String)jobDetail.getExecuteState())) {
                criteria.andExecuteStateEqualTo(jobDetail.getExecuteState());
            }
        }
        return this.jobDetailMapper.deleteByExample(example) > 0;
    }

    @Override
    public Boolean delJobInfoById(Integer id) {
        return this.jobInfoMapper.deleteByPrimaryKey(id) > 0;
    }

    @Override
    public List<TJobInfo> getNeedStartJob() {
        TJobInfoExample example = new TJobInfoExample();
        example.createCriteria().andTaskStateEqualTo("1").andStateEqualTo(DataStateEnum.NORMAL.getState());
        return this.jobInfoMapper.selectByExample(example);
    }
}

