/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.quartz.service.impl;

import com.jhscale.quartz.entity.JobInfoVo;
import com.jhscale.quartz.pojo.TJobInfo;
import com.jhscale.quartz.service.MJobService;
import com.jhscale.quartz.service.MParamCheckService;
import com.ysscale.framework.exception.BusinessException;
import com.ysscale.framework.utils.EntityUtils;
import com.ysscale.framework.utils.JSONUtils;
import com.ysscale.framework.utils.RegexUtil;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MParamCheckServiceImpl
implements MParamCheckService {
    @Autowired
    private MJobService jobService;

    @Override
    public TJobInfo checkAddJobInfoParam(JobInfoVo jobInfo) throws BusinessException {
        if (StringUtils.isBlank((String)jobInfo.getJobName())) {
            throw new BusinessException("\u5b9a\u65f6\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)jobInfo.getCron())) {
            throw new BusinessException("\u5b9a\u65f6\u4efb\u52a1Corn\u8868\u8fbe\u5f0f");
        }
        if (!CronExpression.isValidExpression((String)jobInfo.getCron())) {
            throw new BusinessException("Cron\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isBlank((String)jobInfo.getClazzPath())) {
            throw new BusinessException("\u5b9a\u65f6\u5b9e\u73b0\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!RegexUtil.checkJavaPackage((String)jobInfo.getClazzPath())) {
            throw new BusinessException("\u5b9a\u65f6\u5b9e\u73b0\u7c7b\u4e0d\u5408\u6cd5");
        }
        try {
            Class.forName(jobInfo.getClazzPath());
        }
        catch (ClassNotFoundException e) {
            throw new BusinessException("\u5b9a\u65f6\u4efb\u52a1\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728");
        }
        TJobInfo tJobInfo = (TJobInfo)JSONUtils.beanToBean((Object)jobInfo, TJobInfo.class);
        tJobInfo.setTaskState("0");
        EntityUtils.init((Object)tJobInfo);
        return tJobInfo;
    }

    @Override
    public TJobInfo checkUpdateJobInfoParam(JobInfoVo jobInfo) throws BusinessException {
        if (Objects.isNull(jobInfo.getId())) {
            throw new BusinessException("\u5b9a\u65f6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)jobInfo.getCron()) && !CronExpression.isValidExpression((String)jobInfo.getCron())) {
            throw new BusinessException("Cron\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isNotBlank((String)jobInfo.getClazzPath()) && !RegexUtil.checkJavaPackage((String)jobInfo.getClazzPath())) {
            throw new BusinessException("\u5b9a\u65f6\u5b9e\u73b0\u7c7b\u4e0d\u5408\u6cd5");
        }
        try {
            Class.forName(jobInfo.getClazzPath());
        }
        catch (ClassNotFoundException e) {
            throw new BusinessException("\u5b9a\u65f6\u4efb\u52a1\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728");
        }
        TJobInfo jobInfoById = this.jobService.getJobInfoById(jobInfo.getId());
        if (Objects.isNull(jobInfoById)) {
            throw new BusinessException("\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        return jobInfoById;
    }
}

