/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.quartz.service.impl;

import com.jhscale.quartz.pojo.TJobInfo;
import com.jhscale.quartz.service.MTaskService;
import com.ysscale.framework.exception.SystemException;
import com.ysscale.framework.utils.JSONUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;

@Service
public class MTaskServiceImpl
implements MTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MTaskServiceImpl.class);
    @Autowired
    private SchedulerFactoryBean schedulerFactoryBean;

    @Override
    public boolean checkJob(TJobInfo jobInfo) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobInfo.getId().toString(), (String)"DEFAULT");
        try {
            if (scheduler.checkExists(triggerKey)) {
                return true;
            }
        }
        catch (SchedulerException e) {
            LOGGER.error(JSONUtils.objectToJson((Object)jobInfo) + "\u68c0\u67e5\u8c03\u5ea6\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean startJob(TJobInfo jobInfo) throws SystemException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        try {
            Class<?> clazz = Class.forName(jobInfo.getClazzPath());
            JobDetail jobDetail = JobBuilder.newJob(clazz).build();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobInfo.getId().toString(), (String)"DEFAULT");
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobInfo.getCron())).build();
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (!scheduler.isShutdown()) {
                scheduler.start();
                LOGGER.info("---\u4efb\u52a1[" + triggerKey.getName() + "]\u542f\u52a8\u6210\u529f-------");
            } else {
                LOGGER.info("---\u4efb\u52a1[" + triggerKey.getName() + "]\u5df2\u7ecf\u8fd0\u884c\uff0c\u8bf7\u52ff\u518d\u6b21\u542f\u52a8-------");
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(JSONUtils.objectToJson((Object)jobInfo) + " \u4efb\u52a1\u542f\u52a8\u5f02\u5e38", (Throwable)e);
            throw new SystemException((Throwable)e, jobInfo.getJobName() + " \u4efb\u52a1\u542f\u52a8\u5f02\u5e38");
        }
    }

    @Override
    public boolean removeJob(TJobInfo jobInfo) throws SystemException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobInfo.getId().toString(), (String)"DEFAULT");
        try {
            if (this.checkJob(jobInfo)) {
                scheduler.pauseTrigger(triggerKey);
                scheduler.unscheduleJob(triggerKey);
                scheduler.deleteJob(JobKey.jobKey((String)jobInfo.getId().toString(), (String)"DEFAULT"));
                LOGGER.info("---\u4efb\u52a1[" + triggerKey.getName() + "]\u5220\u9664\u6210\u529f-------");
                return true;
            }
        }
        catch (SchedulerException e) {
            LOGGER.error(JSONUtils.objectToJson((Object)jobInfo) + " \u4efb\u52a1\u505c\u6b62\u5f02\u5e38", (Throwable)e);
            throw new SystemException((Throwable)e, jobInfo.getJobName() + " \u4efb\u52a1\u505c\u6b62\u5f02\u5e38");
        }
        return false;
    }
}

