/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.quartz.task.service.impl;

import com.jhscale.quartz.entity.JobDetailPageRes;
import com.jhscale.quartz.entity.JobDetailVo;
import com.jhscale.quartz.entity.JobInfoPageRes;
import com.jhscale.quartz.entity.JobInfoRes;
import com.jhscale.quartz.entity.JobInfoVo;
import com.jhscale.quartz.entity.JobPageQuery;
import com.jhscale.quartz.pojo.TJobInfo;
import com.jhscale.quartz.service.MJobService;
import com.jhscale.quartz.service.MParamCheckService;
import com.jhscale.quartz.service.MTaskService;
import com.jhscale.quartz.task.service.JobDetailService;
import com.ysscale.framework.exception.BusinessException;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.framework.model.page.Page;
import com.ysscale.framework.utils.EntityUtils;
import com.ysscale.framework.utils.JSONUtils;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobDetailServiceImpl
implements JobDetailService {
    @Autowired
    private MParamCheckService paramCheckService;
    @Autowired
    private MJobService jobService;
    @Autowired
    private MTaskService taskService;

    @Override
    public Page<JobInfoPageRes> showJob(JobPageQuery pageQuery) {
        return this.jobService.getJobPage(pageQuery);
    }

    @Override
    public JobInfoRes getJob(Integer id) {
        TJobInfo jobInfo = this.jobService.getJobInfoById(id);
        return (JobInfoRes)JSONUtils.beanToBean((Object)jobInfo, JobInfoRes.class);
    }

    @Override
    public Boolean addJob(JobInfoVo jobInfo) throws CommonException {
        TJobInfo tJobInfo = this.paramCheckService.checkAddJobInfoParam(jobInfo);
        return this.jobService.add(tJobInfo);
    }

    @Override
    public Boolean updateJob(JobInfoVo jobInfo) throws CommonException {
        TJobInfo tJobInfo = this.paramCheckService.checkUpdateJobInfoParam(jobInfo);
        if (this.taskService.checkJob(tJobInfo)) {
            throw new BusinessException("\u5df2\u7ecf\u542f\u52a8\u4efb\u52a1\u65e0\u6cd5\u66f4\u65b0,\u8bf7\u505c\u6b62\u540e\u66f4\u65b0");
        }
        TJobInfo updateJobInfo = (TJobInfo)JSONUtils.beanToBean((Object)jobInfo, TJobInfo.class);
        EntityUtils.initUpdate((Object)tJobInfo);
        return this.jobService.updateJobInfoById(updateJobInfo);
    }

    @Override
    public Boolean delJob(Integer id) throws CommonException {
        boolean jobState;
        TJobInfo jobInfo = this.jobService.getJobInfoById(id);
        if (Objects.isNull(jobInfo)) {
            throw new BusinessException("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        boolean flag = this.taskService.checkJob(jobInfo);
        boolean bl = jobState = jobInfo.getTaskState().equals("1");
        if (flag && !jobState || !flag && jobState) {
            throw new BusinessException("\u4efb\u52a1\u8868\u72b6\u6001\u548cweb\u4efb\u52a1\u72b6\u6001\u4e0d\u4e00\u81f4,\u65e0\u6cd5\u5220\u9664");
        }
        if (flag) {
            throw new BusinessException("\u8be5\u4efb\u52a1\u5904\u4e8e\u542f\u52a8\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return this.jobService.delJobInfoById(id);
    }

    @Override
    public Page<JobDetailPageRes> showJobDetail(JobPageQuery pageQuery) {
        return this.jobService.showJobDetail(pageQuery);
    }

    @Override
    public Boolean clearJobDetail(JobDetailVo jobDetail) throws CommonException {
        if (!jobDetail.isClearAll() && Objects.isNull(jobDetail.getClearTime()) && Objects.isNull(jobDetail.getDay())) {
            throw new BusinessException("\u91cd\u7f6e\u65f6\u95f4\u6216\u8005\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.jobService.clearJobDetail(jobDetail);
    }
}

