/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.quartz.task.service.impl;

import com.jhscale.quartz.entity.JobExecuteRes;
import com.jhscale.quartz.pojo.TJobInfo;
import com.jhscale.quartz.service.MJobService;
import com.jhscale.quartz.service.MTaskService;
import com.jhscale.quartz.task.service.TaskService;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.framework.utils.EntityUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Autowired
    private MJobService jobService;
    @Autowired
    private MTaskService taskService;

    @Override
    public Boolean startJob(Integer id) throws CommonException {
        TJobInfo jobInfo = this.jobService.getJobInfoById(id);
        if (this.taskService.startJob(jobInfo)) {
            jobInfo.setTaskState("1");
            jobInfo.setStartStopTime(new Date());
            jobInfo.setStartStopMan("wanglie");
            EntityUtils.initUpdate((Object)jobInfo);
            return this.jobService.updateJobInfoById(jobInfo);
        }
        return false;
    }

    @Override
    public List<JobExecuteRes> startJobs(String ids) throws CommonException {
        ArrayList<JobExecuteRes> list = new ArrayList<JobExecuteRes>();
        String[] idArr = ids.split(",");
        if (idArr != null && idArr.length != 0) {
            for (String id : idArr) {
                try {
                    list.add(JobExecuteRes.handleSuccess(id, this.startJob(Integer.parseInt(id))));
                }
                catch (CommonException e) {
                    log.error("start job err --> {}", (Object)e.getMessage(), (Object)e);
                    list.add(JobExecuteRes.handleExp(id, e.getMsg()));
                }
            }
        }
        return list;
    }

    @Override
    public Boolean endJob(Integer id) throws CommonException {
        TJobInfo jobInfo = this.jobService.getJobInfoById(id);
        if (this.taskService.removeJob(jobInfo)) {
            jobInfo.setTaskState("0");
            jobInfo.setStartStopTime(new Date());
            jobInfo.setStartStopMan("wanglie");
            EntityUtils.initUpdate((Object)jobInfo);
            return this.jobService.updateJobInfoById(jobInfo);
        }
        return false;
    }

    @Override
    public List<JobExecuteRes> endJobs(String ids) throws CommonException {
        ArrayList<JobExecuteRes> list = new ArrayList<JobExecuteRes>();
        String[] idArr = ids.split(",");
        if (idArr != null && idArr.length != 0) {
            for (String id : idArr) {
                try {
                    list.add(JobExecuteRes.handleSuccess(id, this.endJob(Integer.parseInt(id))));
                }
                catch (CommonException e) {
                    log.error("end job err --> {}", (Object)e.getMessage(), (Object)e);
                    list.add(JobExecuteRes.handleExp(id, e.getMsg()));
                }
            }
        }
        return list;
    }
}

