package com.meituan.sdk.model.waimaiNg.dish.dishBatchUpload;

import java.util.List;
import javax.validation.constraints.NotBlank;
import com.google.gson.annotations.SerializedName;
import javax.validation.constraints.NotNull;

/**
* <p>菜品列表json字符串， 参考dish说明</p>
* This file was automatically generated.
*/
public class Dishes {
    /**
    * <p>餐盒数量。</p><p>餐盒数量（<strong>boxNum）</strong>，<span style="color: rgba(0, 0, 0, 0.65)"><font style="font-size:14px;line-height:22px" data-size="14">餐盒价格（&nbsp;</font></span><strong>boxPrice）</strong>和<strong>“<span style="color: rgba(0, 0, 0, 0.87)"><font style="font-size:14px;line-height:22px" data-size="14">ladderNum</font></span> ”、“ ladderPrice”</strong>的关系见下表：</p><table class="ct-table"><tbody><tr><th data-colwidth="113" width="113" style="background-color: rgb(249, 250, 251);color: rgba(0, 0, 0, 0.87);vertical-align:inherit;text-align:inherit;"><p></p></th><th data-colwidth="178" width="178" style="background-color: rgb(249, 250, 251);color: rgba(0, 0, 0, 0.87);vertical-align:inherit;text-align:inherit;"><p><strong>boxNum、boxPrice传值</strong></p></th><th data-colwidth="179" width="179" style="background-color: rgb(249, 250, 251);color: rgba(0, 0, 0, 0.87);vertical-align:inherit;text-align:inherit;"><p><strong>boxNum、boxPrice不传值</strong></p></th></tr><tr><td data-colwidth="113" width="113"><p>“ladderNum”和“ladderPrice”传值</p></td><td data-colwidth="178" width="178" style="text-align:inherit;"><p>以“ladderNum”和“ladderPrice”为准，开启阶梯价格</p></td><td data-colwidth="179" width="179" style="text-align:inherit;"><p>以“ladderNum”和“ladderPrice”为准，开启阶梯价格</p></td></tr><tr><td data-colwidth="113" width="113"><p>“ladderNum”和“ladderPrice”不传值</p></td><td data-colwidth="178" width="178" style="text-align:inherit;"><p>以“boxNum”和“boxPrice”为准，关闭阶梯价格</p></td><td data-colwidth="179" width="179" style="text-align:inherit;"><p>1、新增菜品：新建菜品不成功 2、更新菜品：商家端配置不变更</p></td></tr></tbody></table><p></p>
    */
    @SerializedName("boxNum")
    private Float boxNum;
    /**
    * 餐盒价格 不能为负数
    */
    @SerializedName("boxPrice")
    private Float boxPrice;
    /**
    * 菜品分类
    */
    @NotBlank(message = "categoryName不能为空")
    @SerializedName("categoryName")
    private String categoryName;
    /**
    * 菜品描述
    */
    @SerializedName("description")
    private String description;
    /**
    * 菜名，同一分类下菜品名不能重复
    */
    @NotBlank(message = "dishName不能为空")
    @SerializedName("dishName")
    private String dishName;
    /**
    * ERP方菜品Id，不同门店可以重复，同一门店内不能重复，最大长度100
    */
    @NotBlank(message = "eDishCode不能为空")
    @SerializedName("eDishCode")
    private String eDishCode;
    /**
    * ERP方门店Id
    */
    @NotBlank(message = "ePoiId不能为空")
    @SerializedName("ePoiId")
    private String ePoiId;
    /**
    * 菜品上下架状态
    */
    @SerializedName("isSoldOut")
    private Integer isSoldOut;
    /**
    * 最小购买数量
    */
    @SerializedName("minOrderCount")
    private Integer minOrderCount;
    /**
    * 图片id或地址 支持jpg，png格式，图片需要小于1600*1200。
    */
    @SerializedName("picture")
    private String picture;
    /**
    * 分类下菜品的顺序
    */
    @SerializedName("sequence")
    private Integer sequence;
    /**
    * 菜品价格，不能为负数，如果传递了skus价格，本参数可不传
    */
    @NotNull(message = "price不能为空")
    @SerializedName("price")
    private Float price;
    /**
    * 单位/规格
    */
    @SerializedName("unit")
    private String unit;
    /**
    * sku信息
    */
    @SerializedName("skus")
    private List<Skus> skus;
    /**
    * spu售卖属性，spuAttr与skuAttr中的属性数量相同且属性内容相同（mode=2)
    */
    @SerializedName("spuAttr")
    private String spuAttr;
    /**
    * <p><span style="color: "><font style="font-size:14px;line-height:22px" data-size="14">图片URL,多张图片用逗号隔开</font></span></p>
    */
    @SerializedName("pictures")
    private String pictures;
    /**
    * <p><span style="color: "><font style="font-size:14px;line-height:22px" data-size="14">是否设置为招牌商品，最多可以设置15个。1-是，2-否，默认0，不修改该信息</font></span></p>
    */
    @SerializedName("speciality")
    private Integer speciality;
    /**
    * <p><span style="color: "><font style="font-size:14px;line-height:22px" data-size="14">是否设置为单点不送，1-是，2-否，默认0，不修改该信息</font></span></p>
    */
    @SerializedName("isNotSingle")
    private Integer isNotSingle;

    public Float getBoxNum() {
        return boxNum;
    }
    public void setBoxNum(Float boxNum) {
        this.boxNum = boxNum;
    }
    public Float getBoxPrice() {
        return boxPrice;
    }
    public void setBoxPrice(Float boxPrice) {
        this.boxPrice = boxPrice;
    }
    public String getCategoryName() {
        return categoryName;
    }
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    public String getDishName() {
        return dishName;
    }
    public void setDishName(String dishName) {
        this.dishName = dishName;
    }
    public String getEDishCode() {
        return eDishCode;
    }
    public void setEDishCode(String eDishCode) {
        this.eDishCode = eDishCode;
    }
    public String getEPoiId() {
        return ePoiId;
    }
    public void setEPoiId(String ePoiId) {
        this.ePoiId = ePoiId;
    }
    public Integer getIsSoldOut() {
        return isSoldOut;
    }
    public void setIsSoldOut(Integer isSoldOut) {
        this.isSoldOut = isSoldOut;
    }
    public Integer getMinOrderCount() {
        return minOrderCount;
    }
    public void setMinOrderCount(Integer minOrderCount) {
        this.minOrderCount = minOrderCount;
    }
    public String getPicture() {
        return picture;
    }
    public void setPicture(String picture) {
        this.picture = picture;
    }
    public Integer getSequence() {
        return sequence;
    }
    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    public Float getPrice() {
        return price;
    }
    public void setPrice(Float price) {
        this.price = price;
    }
    public String getUnit() {
        return unit;
    }
    public void setUnit(String unit) {
        this.unit = unit;
    }
    public List<Skus> getSkus() {
        return skus;
    }
    public void setSkus(List<Skus> skus) {
        this.skus = skus;
    }
    public String getSpuAttr() {
        return spuAttr;
    }
    public void setSpuAttr(String spuAttr) {
        this.spuAttr = spuAttr;
    }
    public String getPictures() {
        return pictures;
    }
    public void setPictures(String pictures) {
        this.pictures = pictures;
    }
    public Integer getSpeciality() {
        return speciality;
    }
    public void setSpeciality(Integer speciality) {
        this.speciality = speciality;
    }
    public Integer getIsNotSingle() {
        return isNotSingle;
    }
    public void setIsNotSingle(Integer isNotSingle) {
        this.isNotSingle = isNotSingle;
    }




    @Override
    public String toString() {
        return "Dishes{" + "boxNum=" + boxNum + "," + "boxPrice=" + boxPrice + "," + "categoryName=" + categoryName + "," + "description=" + description + "," + "dishName=" + dishName + "," + "eDishCode=" + eDishCode + "," + "ePoiId=" + ePoiId + "," + "isSoldOut=" + isSoldOut + "," + "minOrderCount=" + minOrderCount + "," + "picture=" + picture + "," + "sequence=" + sequence + "," + "price=" + price + "," + "unit=" + unit + "," + "skus=" + skus + "," + "spuAttr=" + spuAttr + "," + "pictures=" + pictures + "," + "speciality=" + speciality + "," + "isNotSingle=" + isNotSingle + "}";
    }
}
