package com.meituan.sdk.model.waimaiNg.dish.dishBatchUpload;

import javax.validation.constraints.NotBlank;
import com.google.gson.annotations.SerializedName;
import javax.validation.constraints.NotNull;

/**
* sku信息
* This file was automatically generated.
*/
public class Skus {
    /**
    * ERP方sku ID
    */
    @NotBlank(message = "skuId不能为空")
    @SerializedName("skuId")
    private String skuId;
    /**
    * 菜品的规格名称，如针对蛋炒饭（SPU）存在3个规格大份、中份、小份（SKU），当菜品只存在一个规格时，建议使用份、位、例等字眼
    */
    @NotBlank(message = "spec不能为空")
    @SerializedName("spec")
    private String spec;
    /**
    * sku的upc码
    */
    @SerializedName("upc")
    private String upc;
    /**
    * 库存数量，stock不能为负数，也不能为小数，传 '*' 表示库存无限
    */
    @NotNull(message = "stock不能为空")
    @SerializedName("stock")
    private Integer stock;
    /**
    * 价格，price不能为负数，不能超过10个字
    */
    @NotNull(message = "price不能为空")
    @SerializedName("price")
    private Float price;
    /**
    * 表示sku起售时间，要保证不同时间段之间不存在交集，默认与门店营业时间一致
    */
    @SerializedName("availableTimes")
    private String availableTimes;
    /**
    * sku的料位码
    */
    @SerializedName("locationCode")
    private String locationCode;
    /**
    * 打包盒数量。如传“boxNum”和“boxPrice”，不要同时传“ladderNum”和“ladderPrice”
    */
    @SerializedName("boxNum")
    private Float boxNum;
    /**
    * 打包盒价格，不能为负数。如传“boxNum”和“boxPrice”，不要同时传“ladderNum”和“ladderPrice”
    */
    @SerializedName("boxPrice")
    private Float boxPrice;
    /**
    * 整形字符串，例如“5”，每M个商品需N元包装费，本字段代表M个商品。不可为0。如传“ladderNum”和“ladderPrice”，则代表商家使用了阶梯价格，“box_num”和“box_price”中的内容不生效
    */
    @SerializedName("ladderNum")
    private String ladderNum;
    /**
    * 每M个商品需N元包装费，本字段代表N元。如传“ladderNum”和“ladderPrice”，则代表商家使用了阶梯价格，“box_num”和“box_price”中的内容不生效
    */
    @SerializedName("ladderPrice")
    private String ladderPrice;
    @SerializedName("sku_sequence")
    private Integer skuSequence;
    /**
    * 填写详细的份量数字，1.填数量(对应weightUnit中 1，2)；2.无需再填数量(对应weightUnit中3)
    */
    @SerializedName("weight")
    private Long weight;
    /**
    * 份量单位，1.克、千克、两、斤、磅、盎司、毫升、升、寸、厘米；2.个、串、枚、粒、 块、只、副、卷、片、贯、碗、杯、袋、瓶、盒、包、锅、罐、扎；3.1人份、2人份、3人份、4人份、5人份、6人份、7人份、8人份、9人份、10人份
    */
    @SerializedName("weightUnit")
    private String weightUnit;
    /**
    * 售卖属性，spuAttr与skuAttr中的属性数量相同且属性内容相同（mode=2)
    */
    @SerializedName("skuAttr")
    private String skuAttr;

    public String getSkuId() {
        return skuId;
    }
    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }
    public String getSpec() {
        return spec;
    }
    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUpc() {
        return upc;
    }
    public void setUpc(String upc) {
        this.upc = upc;
    }
    public Integer getStock() {
        return stock;
    }
    public void setStock(Integer stock) {
        this.stock = stock;
    }
    public Float getPrice() {
        return price;
    }
    public void setPrice(Float price) {
        this.price = price;
    }
    public String getAvailableTimes() {
        return availableTimes;
    }
    public void setAvailableTimes(String availableTimes) {
        this.availableTimes = availableTimes;
    }
    public String getLocationCode() {
        return locationCode;
    }
    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }
    public Float getBoxNum() {
        return boxNum;
    }
    public void setBoxNum(Float boxNum) {
        this.boxNum = boxNum;
    }
    public Float getBoxPrice() {
        return boxPrice;
    }
    public void setBoxPrice(Float boxPrice) {
        this.boxPrice = boxPrice;
    }
    public String getLadderNum() {
        return ladderNum;
    }
    public void setLadderNum(String ladderNum) {
        this.ladderNum = ladderNum;
    }
    public String getLadderPrice() {
        return ladderPrice;
    }
    public void setLadderPrice(String ladderPrice) {
        this.ladderPrice = ladderPrice;
    }
    public Integer getSkuSequence() {
        return skuSequence;
    }
    public void setSkuSequence(Integer skuSequence) {
        this.skuSequence = skuSequence;
    }
    public Long getWeight() {
        return weight;
    }
    public void setWeight(Long weight) {
        this.weight = weight;
    }
    public String getWeightUnit() {
        return weightUnit;
    }
    public void setWeightUnit(String weightUnit) {
        this.weightUnit = weightUnit;
    }
    public String getSkuAttr() {
        return skuAttr;
    }
    public void setSkuAttr(String skuAttr) {
        this.skuAttr = skuAttr;
    }




    @Override
    public String toString() {
        return "Skus{" + "skuId=" + skuId + "," + "spec=" + spec + "," + "upc=" + upc + "," + "stock=" + stock + "," + "price=" + price + "," + "availableTimes=" + availableTimes + "," + "locationCode=" + locationCode + "," + "boxNum=" + boxNum + "," + "boxPrice=" + boxPrice + "," + "ladderNum=" + ladderNum + "," + "ladderPrice=" + ladderPrice + "," + "skuSequence=" + skuSequence + "," + "weight=" + weight + "," + "weightUnit=" + weightUnit + "," + "skuAttr=" + skuAttr + "}";
    }
}
