package com.meituan.sdk.model.waimaiNg.order.zbDispatch;

import com.meituan.sdk.annotations.ApiMeta;
import com.google.gson.reflect.TypeToken;
import javax.validation.constraints.NotBlank;
import java.lang.reflect.Type;
import com.meituan.sdk.internal.utils.JsonUtil;
import com.google.gson.annotations.SerializedName;
import javax.validation.constraints.NotNull;
import com.meituan.sdk.MeituanResponse;
import com.meituan.sdk.MeituanRequest;

/**
* 众包配送-发配送
* This file was automatically generated.
*/
@ApiMeta(
    path = "/waimai/order/zbDispatch",
    businessId = 2,
    apiVersion = "10000",
    apiName = "zb_dispatch",
    needAuth = false
)
public class ZbDispatchRequest implements MeituanRequest<String> {
    /**
    * <p><span style="color: rgba(0, 0, 0, 0.87)"><font style="font-size:14px;line-height:22px" data-size="14">配送费</font></span></p>
    */
    @NotNull(message = "shippingFee不能为空")
    @SerializedName("shippingFee")
    private Double shippingFee;
    /**
    * <p><span style="color: rgba(0, 0, 0, 0.87)"><font style="font-size:14px;line-height:22px" data-size="14">订单号</font></span></p>
    */
    @NotBlank(message = "orderId不能为空")
    @SerializedName("orderId")
    private String orderId;
    /**
    * <p>小费</p>
    */
    @NotNull(message = "tipAmount不能为空")
    @SerializedName("tipAmount")
    private Double tipAmount;
    /**
    * <p>配送优惠券id</p>
    */
    @SerializedName("couponViewId")
    private String couponViewId;

    public Double getShippingFee() {
        return shippingFee;
    }
    public void setShippingFee(Double shippingFee) {
        this.shippingFee = shippingFee;
    }
    public String getOrderId() {
        return orderId;
    }
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }
    public Double getTipAmount() {
        return tipAmount;
    }
    public void setTipAmount(Double tipAmount) {
        this.tipAmount = tipAmount;
    }
    public String getCouponViewId() {
        return couponViewId;
    }
    public void setCouponViewId(String couponViewId) {
        this.couponViewId = couponViewId;
    }


    @Override
    public MeituanResponse<String> deserializeResponse(String response) {
        Type type = new TypeToken<MeituanResponse<String>>(){}.getType();
        return JsonUtil.fromJson(response, type);
    }
    @Override
    public String serializeToJson() {
        return JsonUtil.toJson(this);
    }


    @Override
    public String toString() {
        return "ZbDispatchRequest{" + "shippingFee=" + shippingFee + "," + "orderId=" + orderId + "," + "tipAmount=" + tipAmount + "," + "couponViewId=" + couponViewId + "}";
    }
}
