/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sdk;

import com.google.gson.JsonSyntaxException;
import com.meituan.sdk.CommonRequest;
import com.meituan.sdk.MeituanClient;
import com.meituan.sdk.MeituanRequest;
import com.meituan.sdk.MeituanResponse;
import com.meituan.sdk.domain.ApiMetaInfo;
import com.meituan.sdk.internal.enums.SdkError;
import com.meituan.sdk.internal.exceptions.MtSdkException;
import com.meituan.sdk.internal.http.DefaultHttpClient;
import com.meituan.sdk.internal.http.HttpClient;
import com.meituan.sdk.internal.http.HttpConfig;
import com.meituan.sdk.internal.utils.AnnotationUtil;
import com.meituan.sdk.internal.utils.JsonUtil;
import com.meituan.sdk.internal.utils.SignerUtil;
import com.meituan.sdk.internal.utils.StringUtil;
import com.meituan.sdk.internal.utils.ValidationUtil;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMeituanClient
implements MeituanClient {
    private String serverUrl;
    private Long developerId;
    private String signKey;
    private String version;
    private String charset;
    private HttpClient httpClient;
    private HttpConfig httpConfig;
    private static final Logger logger = LoggerFactory.getLogger(DefaultMeituanClient.class);

    private DefaultMeituanClient(String serverUrl, String signKey, String charset, String version, Long developerId, HttpClient httpClient, HttpConfig httpConfig) {
        this.developerId = developerId;
        this.signKey = signKey;
        this.serverUrl = serverUrl;
        this.charset = charset;
        this.version = version;
        this.httpClient = httpClient;
        this.httpConfig = httpConfig;
    }

    @Override
    public <T> MeituanResponse<T> invokeApi(MeituanRequest<T> request) throws MtSdkException {
        return this.invokeApi(request, null, null, null);
    }

    @Override
    public <T> MeituanResponse<T> invokeApi(MeituanRequest<T> request, String appAuthToken) throws MtSdkException {
        return this.invokeApi(request, appAuthToken, null, null);
    }

    @Override
    public <T> MeituanResponse<T> invokeApi(MeituanRequest<T> request, Integer connectTimeout, Integer readTimeout) throws MtSdkException {
        return this.invokeApi(request, null, connectTimeout, readTimeout);
    }

    @Override
    public <T> MeituanResponse<T> invokeApi(MeituanRequest<T> request, String appAuthToken, Integer connectTimeout, Integer readTimeout) throws MtSdkException {
        if (Objects.isNull(request)) {
            logger.error("request\u53c2\u6570\u4e0d\u80fd\u4e3aNULL");
            throw new MtSdkException(SdkError.MISS_PARAM_ERROR);
        }
        logger.info("request:{},developerId:{},appAuthToken:{}", new Object[]{request.serializeToJson(), this.developerId, appAuthToken});
        if (Objects.nonNull(connectTimeout)) {
            this.httpConfig.setConnectTimeout(connectTimeout);
        }
        if (Objects.nonNull(readTimeout)) {
            this.httpConfig.setReadTimeout(readTimeout);
        }
        ApiMetaInfo apiMetaInfo = AnnotationUtil.getApiMeta(request);
        this.verifyParams(request, apiMetaInfo, appAuthToken);
        String url = this.serverUrl + apiMetaInfo.getPath();
        String resp = this.execute(url, request.serializeToJson(), apiMetaInfo.getBusinessId(), appAuthToken);
        if (StringUtil.isEmpty(resp)) {
            logger.error("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0curl:{}\uff0cRequest:{}\uff0capiMetaInfo:{}", new Object[]{url, request.serializeToJson(), apiMetaInfo});
            throw new MtSdkException(SdkError.REQUEST_FAILED_ERROR.getCode(), SdkError.REQUEST_FAILED_ERROR.getMsg());
        }
        try {
            return request.deserializeResponse(resp);
        }
        catch (JsonSyntaxException e) {
            logger.error("\u89e3\u6790\u8bf7\u6c42\u8fd4\u56de\u503c\u4e3aResponse\u5931\u8d25\uff0crequest:{}, apiMetaInfo:{}, resp:{}", new Object[]{request.serializeToJson(), apiMetaInfo, resp, e});
            throw new MtSdkException(SdkError.PARSE_RESPONSE_ERROR, (Throwable)e);
        }
    }

    @Override
    public <T> MeituanResponse<T> commonInvokeApi(CommonRequest request, Type responseType) throws MtSdkException {
        if (Objects.isNull(request)) {
            logger.error("request\u53c2\u6570\u4e0d\u80fd\u4e3aNULL");
            throw new MtSdkException(SdkError.MISS_PARAM_ERROR);
        }
        logger.info("request:{},developerId:{}", (Object)JsonUtil.toJson(request), (Object)this.developerId);
        if (Objects.nonNull(request.getConnectTimeout())) {
            this.httpConfig.setConnectTimeout(request.getConnectTimeout());
        }
        if (Objects.nonNull(request.getReadTimeout())) {
            this.httpConfig.setReadTimeout(request.getReadTimeout());
        }
        ValidationUtil.validate(request);
        String url = this.serverUrl + request.getApiPath();
        String resp = this.execute(url, JsonUtil.toJson(request.getBizParams()), request.getBusinessId(), request.getAppAuthToken());
        if (StringUtil.isEmpty(resp)) {
            logger.error("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0curl:{}\uff0cRequest:{}", (Object)url, (Object)JsonUtil.toJson(request));
            throw new MtSdkException(SdkError.REQUEST_FAILED_ERROR.getCode(), SdkError.REQUEST_FAILED_ERROR.getMsg());
        }
        try {
            return (MeituanResponse)JsonUtil.fromJson(resp, responseType);
        }
        catch (JsonSyntaxException e) {
            logger.error("\u89e3\u6790\u8bf7\u6c42\u8fd4\u56de\u503c\u4e3aresponseType\u5bf9\u5e94\u7684\u5bf9\u8c61\u5931\u8d25\uff0crequest:{}, resp:{}, responseType:{}", new Object[]{request, resp, responseType.getTypeName(), e});
            throw new MtSdkException(SdkError.PARSE_RESPONSE_ERROR, (Throwable)e);
        }
    }

    private String execute(String url, String bizParams, Integer businessId, String appAuthToken) throws MtSdkException {
        Map<String, String> queryContentMap = this.buildQueryContentMap(bizParams, businessId, appAuthToken);
        Map<String, String> headers = this.buildHeaders();
        logger.info("url:{},queryContentMap:{},httpConfig:{}", new Object[]{url, queryContentMap, this.httpConfig});
        return this.httpClient.postWithUrlEncoded(url, queryContentMap, headers, this.httpConfig);
    }

    private Map<String, String> buildQueryContentMap(String bizParams, Integer businessId, String appAuthToken) throws MtSdkException {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("biz", bizParams);
        queryMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        queryMap.put("businessId", String.valueOf(businessId));
        queryMap.put("developerId", this.developerId.toString());
        queryMap.put("charset", this.charset);
        queryMap.put("version", this.version);
        if (!StringUtil.isEmpty(appAuthToken)) {
            queryMap.put("appAuthToken", appAuthToken);
        }
        queryMap.put("sign", SignerUtil.getSign(this.signKey, queryMap));
        return queryMap;
    }

    private void verifyParams(MeituanRequest<?> request, ApiMetaInfo apiMetaInfo, String appAuthToken) throws MtSdkException {
        if (apiMetaInfo.isNeedAuth() && StringUtil.isEmpty(appAuthToken)) {
            logger.error("\u6b64\u63a5\u53e3\u9700\u8981\u9274\u6743\uff0c\u7f3a\u5c11appAuthToken\u53c2\u6570, request:{}, apiMetaInfo:{}", (Object)request.serializeToJson(), (Object)apiMetaInfo);
            throw new MtSdkException(SdkError.MISS_APPAUTHTOKEN_ERROR.getCode(), SdkError.MISS_APPAUTHTOKEN_ERROR.getMsg());
        }
        ValidationUtil.validate(request);
    }

    private Map<String, String> buildHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Sdk-Info", "java-1.0.1");
        headers.put("DeveloperId", this.developerId.toString());
        return headers;
    }

    public static Builder builder(Long developerId, String signKey) {
        return new Builder(developerId, signKey);
    }

    public static class Builder {
        private String serverUrl = "https://api-open-cater.meituan.com";
        private String charset = "UTF-8";
        private HttpClient httpClient = new DefaultHttpClient();
        private String version = "2";
        private String signKey;
        private Long developerId;
        private HttpConfig httpConfig = new HttpConfig();

        private Builder(Long developerId, String signKey) {
            this.developerId = developerId;
            this.signKey = signKey;
        }

        public Builder charset(String name) {
            this.charset = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder httpUtil(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder connectTimeout(Integer connectTimeout) {
            this.httpConfig.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder readTimeout(Integer readTimeout) {
            this.httpConfig.setReadTimeout(readTimeout);
            return this;
        }

        public Builder needSSLCheck(Boolean needSSLCheck) {
            this.httpConfig.setNeedSSLCheck(needSSLCheck);
            return this;
        }

        public DefaultMeituanClient build() {
            return new DefaultMeituanClient(this.serverUrl, this.signKey, this.charset, this.version, this.developerId, this.httpClient, this.httpConfig);
        }
    }
}

