/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sdk.internal.utils;

import com.meituan.sdk.internal.enums.SdkError;
import com.meituan.sdk.internal.exceptions.MtSdkException;
import com.meituan.sdk.internal.utils.JsonUtil;
import java.util.Objects;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ValidationUtil.class);
    private static final Validator validator = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false)).buildValidatorFactory().getValidator();

    public static <T> void validate(T obj) throws MtSdkException {
        Set validateSet = validator.validate(obj, new Class[0]);
        if (Objects.nonNull(validateSet) && !validateSet.isEmpty()) {
            logger.error("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0crequest:{}", (Object)JsonUtil.toJson(obj));
            String messages = validateSet.stream().map(ConstraintViolation::getMessage).reduce((m1, m2) -> m1 + "," + m2).orElse("\u53c2\u6570\u8f93\u5165\u6709\u8bef\uff01");
            throw new MtSdkException(SdkError.VERIFY_PARAM_ERROR.getCode(), SdkError.VERIFY_PARAM_ERROR.getMsg() + messages);
        }
    }
}

