package com.ysscale.mall.admin.client;

import com.ysscale.mall.admin.client.hystrix.AdminProgramClientHystrix;
import com.ysscale.mall.admin.vo.AuthorizedReq;
import com.ysscale.mall.admin.vo.CancelAuthorized;
import com.ysscale.mall.admin.vo.UpdateMiniProgramReq;
import com.ysscale.mall.admin.vo.UpdateMiniProgramStateReq;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author 侯存路
 * @date 2019/2/25
 * @company codingApi
 * @description
 */
@FeignClient(value = "server-mall-admin", fallback = AdminProgramClientHystrix.class)
public interface AdminProgramClient {


    /**
     * 注册审核事件推送
     */
    @PostMapping("/admin/mq/updateMiniProgramByRegister")
    boolean  updateMiniProgramByRegister (@RequestBody UpdateMiniProgramReq updateMiniProgramReq);


    /**
     * 授权成功通知
     * @param
     */
    @PostMapping("/admin/mq/authorized")
    boolean  authorized (@RequestBody AuthorizedReq authorizedReq);


    /**
     * 取消授权
     * @param
     */
    @PostMapping("/admin/mq/cancelAuthorized")
    boolean  cancelAuthorized (@RequestBody CancelAuthorized cancelAuthorized);


    /**
     * 修改小程序审核状态
     * @param
     */
    @PostMapping("/admin/mq/updateMiniProgramState")
    boolean updateMiniProgramState(@RequestBody UpdateMiniProgramStateReq umpr);
}
