package com.ysscale.mall.admin.vo;

import lombok.Data;

import java.util.Date;

/**
 * @author 侯存路
 * @date 2019/2/27
 * @company codingApi
 * @description
 */
@Data
public class AuthorizedReq {


    /**
     * 第三方平台AppId
     */
    private  String  appId;

    /**
     * 授权的小程序AppId
     */
    private  String  authorizerAppId;

    /**
     * 日期
     */
    private String createTime;


    /**
     * 微信推送事件类型
     */
    private  String  InfoType;

    /**
     * 授权码
     */
    private  String  authorizationCode;

    /**
     * 过期时间
     */
    private  String  authorizationCodeExpiredTime;

    /**
     * 预授权码
     */
    private  String  preAuthCode;


    /**
     * 授权方接口调用凭据（在授权的公众号或小程序具备API权限时，才有此返回值），也简称为令牌
     */
    private  String   authorizerAccessToken;


    /**
     *   令牌到期时间
     */
    private  String   expiresIn;


    /**
     *   接口调用凭据刷新令牌（在授权的公众号具备API权限时，才有此返回值），
     *   刷新令牌主要用于第三方平台获取和刷新已授权用户的access_token，只会在授权时刻提供，请妥善保存。
     *   一旦丢失，只能让用户重新授权，才能再次拿到新的刷新令牌
     */
    private String  authorizerRefreshToken;


    /**
     *   授权给开发者的权限集列表， 具体内容参考  微信开发文档
     */
    private  String  funcInfo;



}
