package com.ysscale.interviewapi.client;

import com.ysscale.interviewapi.client.hystrix.InterviewApiClientHystrix;
import com.ysscale.interviewapi.vo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author 侯存路
 * @date 2018/5/22
 * @company codingApi
 * @description
 */
@FeignClient(value = "server-interview-api", fallback = InterviewApiClientHystrix.class)
public interface InterviewApiClient {


    /***  支付宝  ******/
    /**
     * 支付授权
     *
     * @param payAuthorizationReqVo
     * @return
     */
    @PostMapping("/aliPay/payAuthorization")
    AliPayAuthorizationResVo payAuthorization(@RequestBody AliPayAuthorizationReqVo payAuthorizationReqVo);

    /**
     * 支付令牌刷新
     *
     * @param payAuthorizationReqVo
     * @return
     */
    @PostMapping("/aliPay/payAuthorization")
    AliPayAuthorizationResVo payTokenRefresh(@RequestBody AliPayAuthorizationReqVo payAuthorizationReqVo);


    /**
     * 查询订单
     *
     * @param queryOrderResVO
     * @return
     */
    @PostMapping("/aliPay/queryOrder")
    QueryOrderResVO aliQueryOrder(@RequestBody QueryOrderReqVO queryOrderResVO);


    /**
     * 关闭订单
     *
     * @param closeOrderReqVO
     * @return
     */
    @PostMapping("/aliPay/closeOrder")
    CloseOrderResVO aliCloseOrder(@RequestBody CloseOrderReqVO closeOrderReqVO);


    /**
     * 撤销订单
     *
     * @param cancelOrderReqVO
     * @return
     */

    @PostMapping("/aliPay/cancelOrder")
    CancelOrderResVO aliCancelOrder(@RequestBody CancelOrderReqVO cancelOrderReqVO);


    /**
     * 创建订单
     *
     * @param
     * @return
     */
    @PostMapping("/aliPay/createOrder")
    CreateOrderResVO aliCreateOrder(@RequestBody CreateOrderReqVO createOrderReqVO);


    /**
     * 退款订单
     *
     * @param refundOrderReqAO
     * @return
     */
    @PostMapping("/aliPay/refundOrder")
    RefundOrderResVO aliRefundOrder(@RequestBody RefundOrderReqVO refundOrderReqAO);

    /**
     * 查询对账下载地址
     *
     * @param checkBillReqVo
     * @return
     */
    @PostMapping("/aliPay/downloadbillUrl")
    CheckBillResVo alidownloadbillUrl(@RequestBody CheckBillReqVo checkBillReqVo);


    /***  微信  ******/


    /**
     * 查询订单
     *
     * @param wxQueryOrderReqVO
     * @return
     */
    @PostMapping("/wxPay/queryOrder")
    WxQueryOrderResVO wxQueryOrder(@RequestBody WxQueryOrderReqVO wxQueryOrderReqVO);


    /**
     * 撤销订单
     *
     * @param cancelOrderReqAO
     * @return
     */
    @PostMapping("/wxPay/cancelOrder")
    WxCancelOrderResVO wxCancelOrder(@RequestBody WxCancelOrderReqVO cancelOrderReqAO);


    /**
     * 创建订单
     *
     * @param wxCreateOrderReqVO
     * @return
     */
    @PostMapping("/wxPay/createOrder")
    WxCreateOrderResVO wxCreateOrder(@RequestBody WxCreateOrderReqVO wxCreateOrderReqVO);


    /**
     * 退款订单
     *
     * @param refundOrderReqAO
     * @return
     */
    @PostMapping("/wxPay/refundOrder")
    WxRefundOrderResVO wxRefundOrder(@RequestBody WxRefundOrderReqVO refundOrderReqAO);

    /**
     * 下载对账单
     *
     * @param wxCheckBillReqVO
     * @return
     */
    @PostMapping("/wxPay/downloadbillUrl")
    public WxCheckBillResVO wxDownloadbillUrl(@RequestBody WxCheckBillReqVO wxCheckBillReqVO);


}
