package com.ysscale.interviewapi.client;

import com.ysscale.interviewapi.client.hystrix.InterviewMsgClientHystirx;
import com.ysscale.interviewapi.vo.MsgSendReq;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @program: ysscale_core
 * @description:
 * @author: zhao
 * @create: 2018-12-12 09:11
 **/
@FeignClient(value = "server-interview-api", fallback = InterviewMsgClientHystirx.class)
public interface InterviewMsgClient {

    /**
     * 发送短信
     */

    @PostMapping("/send/sendPMsg")
    boolean sendPMsg(@RequestBody MsgSendReq msgSendReq);

    /**
     * 发送邮件
     */
    @PostMapping("/send/sendEMsg")
    boolean sendEMsg(@RequestBody MsgSendReq msgSendReq);
}
