package com.ysscale.interviewapi.client.hystrix;

import com.ysscale.framework.core.content.VirtualNumber;
import com.ysscale.interviewapi.client.InterviewApiClient;
import com.ysscale.interviewapi.vo.*;
import com.ysscale.message.utils.SendMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @author 侯存路
 * @date 2018/5/22
 * @company codingApi
 * @description
 */
@Component
public class InterviewApiClientHystrix implements InterviewApiClient {


    private static final Logger LOGGER = LoggerFactory.getLogger(InterviewApiClientHystrix.class);


    @Override
    public AliPayAuthorizationResVo payAuthorization(AliPayAuthorizationReqVo payAuthorizationReqVo) {
        LOGGER.error("server-interview-api / ali payAuthorization : 断路器异常！");
        AliPayAuthorizationResVo authorizationResVo = new AliPayAuthorizationResVo();
        authorizationResVo.setCode("60000");
        authorizationResVo.setMsg("err");
        authorizationResVo.setSubCode("50000");
        authorizationResVo.setSubMsg("server-interview-api/ali queryOrder:断路异常");
        return authorizationResVo;
    }

    @Override
    public AliPayAuthorizationResVo payTokenRefresh(AliPayAuthorizationReqVo payAuthorizationReqVo) {
        LOGGER.error("server-interview-api / ali payTokenRefresh : 断路器异常！");
        AliPayAuthorizationResVo authorizationResVo = new AliPayAuthorizationResVo();
        authorizationResVo.setCode("60000");
        authorizationResVo.setMsg("err");
        authorizationResVo.setSubMsg("server-interview-api/ali queryOrder:断路异常");
        return authorizationResVo;
    }

    @Override
    public QueryOrderResVO aliQueryOrder(QueryOrderReqVO queryOrderResAO) {
        LOGGER.error("server-interview-api / ali queryOrder : 断路器异常！");
        QueryOrderResVO queryOrderResVO = new QueryOrderResVO();
        queryOrderResVO.setCode("60000");
        queryOrderResVO.setMsg("err");
        queryOrderResVO.setSubMsg("server-interview-api/ali queryOrder:断路异常");
        return queryOrderResVO;
    }

    @Override
    public CloseOrderResVO aliCloseOrder(CloseOrderReqVO closeOrderReqVO) {
        LOGGER.error("server-interview-api / ali closeOrder : 断路器异常！");
        CloseOrderResVO closeOrderResVO = new CloseOrderResVO();
        closeOrderResVO.setCode("60000");
        closeOrderResVO.setMsg("err");
        closeOrderResVO.setSubMsg("server-interview-api/ali closeOrder:断路异常");
        return closeOrderResVO;
    }

    @Override
    public CancelOrderResVO aliCancelOrder(CancelOrderReqVO cancelOrderReqVO) {
        LOGGER.error("server-interview-api / ali cancelOrder : 断路器异常！");
        CancelOrderResVO cancelOrderResVO = new CancelOrderResVO();
        cancelOrderResVO.setCode("60000");
        cancelOrderResVO.setMsg("err");
        cancelOrderResVO.setSubMsg("server-interview-api/ali cancelOrder:断路异常");
        return cancelOrderResVO;
    }

    @Override
    public CreateOrderResVO aliCreateOrder(CreateOrderReqVO createOrderReqVO) {
        LOGGER.error("server-interview-api  / ali createOrder : 断路器异常！");
        CreateOrderResVO createOrderResVO = new CreateOrderResVO();
        createOrderResVO.setCode(VirtualNumber.FEIGN_TIMEOUT);
        createOrderResVO.setMsg("err");
        createOrderResVO.setSubMsg("server-interview-api/ali createOrder:断路异常");
        return createOrderResVO;
    }

    @Override
    public RefundOrderResVO aliRefundOrder(RefundOrderReqVO refundOrderReqAO) {
        LOGGER.error("server-interview-api  / ali refundOrder : 断路器异常！");
        RefundOrderResVO refundOrderResVO = new RefundOrderResVO();
        refundOrderResVO.setCode("60000");
        refundOrderResVO.setMsg("err");
        refundOrderResVO.setSubMsg("server-interview-api/ali refundOrder:断路异常");
        return refundOrderResVO;
    }

    @Override
    public CheckBillResVo alidownloadbillUrl(CheckBillReqVo checkBillReqVo) {
        LOGGER.error("server-interview-api  / ali downloadbillUrl : 断路器异常！");
        CheckBillResVo checkBillResVo = new CheckBillResVo();
        checkBillResVo.setCode("60000");
        checkBillResVo.setMsg("err");
        checkBillResVo.setSubMsg("server-interview-api/ali downloadbillUrl:断路异常");
        return checkBillResVo;
    }


    @Override
    public WxQueryOrderResVO wxQueryOrder(WxQueryOrderReqVO wxQueryOrderReqVO) {
        LOGGER.error("server-interview-api /Wx  queryOrder : 断路器异常！");
        WxQueryOrderResVO wxQueryOrderResVO = new WxQueryOrderResVO();
        wxQueryOrderResVO.setReturnCode("LINKTIMEOUT");
        wxQueryOrderResVO.setReturnMsg("server-interview-api /Wx  queryOrder : 断路器异常！");
        return wxQueryOrderResVO;
    }

    @Override
    public WxCancelOrderResVO wxCancelOrder(WxCancelOrderReqVO cancelOrderReqAO) {
        LOGGER.error("server-interview-api /Wx  cancelOrder : 断路器异常！");
        WxCancelOrderResVO wxCancelOrderResVO = new WxCancelOrderResVO();
        wxCancelOrderResVO.setReturnCode("FAIL");
        wxCancelOrderResVO.setReturnMsg("server-interview-api /Wx  cancelOrder : 断路器异常！");
        return wxCancelOrderResVO;
    }

    @Override
    public WxCreateOrderResVO wxCreateOrder(WxCreateOrderReqVO wxCreateOrderReqVO) {
        LOGGER.error("server-interview-api /Wx  createOrder : 断路器异常！");
        WxCreateOrderResVO wxCreateOrderResVO = new WxCreateOrderResVO();
        wxCreateOrderResVO.setReturnCode(VirtualNumber.FEIGN_TIMEOUT);
        wxCreateOrderResVO.setReturnMsg("server-interview-api /Wx  createOrder : 断路器异常！");
        return wxCreateOrderResVO;
    }

    @Override
    public WxRefundOrderResVO wxRefundOrder(WxRefundOrderReqVO refundOrderReqAO) {
        LOGGER.error("server-interview-api /Wx  refundOrder : 断路器异常！");
        WxRefundOrderResVO wxRefundOrderResVO = new WxRefundOrderResVO();
        wxRefundOrderResVO.setReturnCode("FAIL");
        wxRefundOrderResVO.setReturnMsg("server-interview-api /Wx  refundOrder : 断路器异常！");
        return wxRefundOrderResVO;
    }

    @Override
    public WxCheckBillResVO wxDownloadbillUrl(WxCheckBillReqVO wxCheckBillReqVO) {
        LOGGER.error("server-interview-api /Wx  wxDownloadbillUrl : 断路器异常！");
        WxCheckBillResVO wxRefundOrderResVO = new WxCheckBillResVO();
        wxRefundOrderResVO.setReturnCode("FAIL");
        wxRefundOrderResVO.setReturnMsg("server-interview-api /Wx  wxDownloadbillUrl : 断路器异常！");
        return wxRefundOrderResVO;
    }


}
