package com.ysscale.interviewapi.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * @ProjectName: ysscale_core
 * @Package: com.ysscale.pay.vo
 * @ClassName: AliPayAuthorizationResVo
 * @Description: java类作用描述
 * @Author: 王列
 * @CreateDate: 2018/5/31 14:38
 * @UpdateUser: 更新者
 * @UpdateDate: 2018/5/31 14:38
 * @UpdateRemark: 更新说明
 * @Version: 1.0
 */
public class AliPayAuthorizationResVo {

    /**
     * 10000 为调用正常 ， 其他为异常 异常信息在 subCode / subMsg
     */
    private String code;


    /**
     * 网关返回码描述
     */
    private String msg;

    /**
     * 业务返回码    / 仅在接口调用失败时有值
     */
    private String subCode;

    /**
     * 业务返回码描述 / 仅在接口调用失败时有值
     */
    private String subMsg;

    /**
     * 商户PID
     */
    private String pId;

    /**
     * 支付宝支付令牌
     */
    private String payAliToken;

    /**
     * 支付宝刷新令牌
     */
    private String refreshAliToken;

    /**
     * 支付宝令牌失效时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date aliTokenCreate;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getSubCode() {
        return subCode;
    }

    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    public String getSubMsg() {
        return subMsg;
    }

    public void setSubMsg(String subMsg) {
        this.subMsg = subMsg;
    }

    public String getpId() {
        return pId;
    }

    public void setpId(String pId) {
        this.pId = pId;
    }

    public String getPayAliToken() {
        return payAliToken;
    }

    public void setPayAliToken(String payAliToken) {
        this.payAliToken = payAliToken;
    }

    public String getRefreshAliToken() {
        return refreshAliToken;
    }

    public void setRefreshAliToken(String refreshAliToken) {
        this.refreshAliToken = refreshAliToken;
    }

    public Date getAliTokenCreate() {
        return aliTokenCreate;
    }

    public void setAliTokenCreate(Date aliTokenCreate) {
        this.aliTokenCreate = aliTokenCreate;
    }
}
