/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.network.client;

import com.jhscale.network.client.MarketClient;
import com.jhscale.network.entity.food.BaseMarketRequest;
import com.jhscale.network.entity.food.BaseMarketResponse;
import com.jhscale.network.entity.telecom.res.TelecomTokenInfo;
import com.ysscale.framework.utils.JSONUtils;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestTemplate;

public abstract class BaseMarketClient<T, LR extends BaseMarketResponse, LQ extends BaseMarketRequest<LR>>
implements MarketClient {
    private static final Logger log = LoggerFactory.getLogger(BaseMarketClient.class);
    private RestTemplate restTemplate;
    private RestTemplate httpsRestTemplate;

    public abstract String getLogPrefix();

    protected abstract <R extends BaseMarketResponse> void setToken(HttpHeaders var1, BaseMarketRequest<R> var2) throws Exception;

    protected abstract boolean tokenExpire(T var1);

    public abstract T getTokenBean(String var1) throws Exception;

    public abstract String getToken(String var1) throws Exception;

    protected abstract void saveToken(String var1, TelecomTokenInfo var2);

    public abstract LR login(LQ var1) throws Exception;

    public boolean tokenExpire(String marketId) throws Exception {
        T tokenBean = this.getTokenBean(marketId);
        return this.tokenExpire(tokenBean);
    }

    public String getUrl(BaseMarketRequest request) {
        return request.getUrlPrefix() + request.url();
    }

    public boolean isLogin(String marketId) throws Exception {
        T tokenBean = this.getTokenBean(marketId);
        if (Objects.isNull(tokenBean)) {
            return false;
        }
        return this.tokenExpire(tokenBean);
    }

    private RestTemplate getRestTemplate() {
        if (Objects.isNull(this.restTemplate)) {
            this.restTemplate = new RestTemplate();
        }
        return this.restTemplate;
    }

    private RestTemplate getHttpsRestTemplate() {
        if (Objects.isNull(this.httpsRestTemplate)) {
            this.httpsRestTemplate = new RestTemplate();
            SSLContext sslContext = null;
            try {
                sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
            this.httpsRestTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        }
        return this.httpsRestTemplate;
    }

    public <R extends BaseMarketResponse> R postHttpsForm(BaseMarketRequest<R> request, HttpHeaders headers) {
        if (Objects.isNull(headers)) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        BaseMarketRequest<R> realRequest = request.parseRequest();
        if (Objects.isNull(realRequest)) {
            realRequest = request;
        }
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.setAll((Map)JSONUtils.beanToBean(realRequest, HashMap.class));
        HttpEntity requestBody = new HttpEntity((Object)formData, (MultiValueMap)headers);
        String url = this.getUrl(request);
        ResponseEntity response = this.getHttpsRestTemplate().postForEntity(url, (Object)requestBody, request.resClass(), new Object[0]);
        log.debug("{}---\u8bf7\u6c42  marketId:{}-------url:{}-------\u8bf7\u6c42\u53c2\u6570\uff1a{}-------\u54cd\u5e94\uff1a{}", new Object[]{this.getLogPrefix(), request.marketId(), url, JSONUtils.objectToJson(request), JSONUtils.objectToJson((Object)response)});
        return (R)((BaseMarketResponse)response.getBody());
    }

    public <R extends BaseMarketResponse> R postHttps(BaseMarketRequest<R> request, HttpHeaders headers) {
        if (Objects.isNull(headers)) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_JSON);
        BaseMarketRequest<R> realRequest = request.parseRequest();
        if (Objects.isNull(realRequest)) {
            realRequest = request;
        }
        HttpEntity requestBody = new HttpEntity(realRequest, (MultiValueMap)headers);
        String url = this.getUrl(request);
        ResponseEntity response = this.getHttpsRestTemplate().postForEntity(url, (Object)requestBody, request.resClass(), new Object[0]);
        log.debug("{}---\u8bf7\u6c42  marketId:{}-------url:{}-------\u8bf7\u6c42\u53c2\u6570\uff1a{}-------\u54cd\u5e94\uff1a{}", new Object[]{this.getLogPrefix(), request.marketId(), url, JSONUtils.objectToJson(request), JSONUtils.objectToJson((Object)response)});
        return (R)((BaseMarketResponse)response.getBody());
    }

    public <R extends BaseMarketResponse> R basePost(BaseMarketRequest<R> request, HttpHeaders headers) {
        if (Objects.isNull(headers)) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_JSON);
        BaseMarketRequest<R> realRequest = request.parseRequest();
        if (Objects.isNull(realRequest)) {
            realRequest = request;
        }
        HttpEntity requestBody = new HttpEntity(realRequest, (MultiValueMap)headers);
        String url = this.getUrl(request);
        ResponseEntity response = this.getRestTemplate().postForEntity(url, (Object)requestBody, request.resClass(), new Object[0]);
        log.debug("{}---\u8bf7\u6c42  marketId:{}-------url:{}-------\u8bf7\u6c42\u53c2\u6570\uff1a{}-------\u54cd\u5e94\uff1a{}", new Object[]{this.getLogPrefix(), request.marketId(), url, JSONUtils.objectToJson(request), JSONUtils.objectToJson((Object)response)});
        return (R)((BaseMarketResponse)response.getBody());
    }

    public <R extends BaseMarketResponse> R baseGet(BaseMarketRequest<R> request, HttpHeaders httpHeaders) {
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestBody = new HttpEntity((MultiValueMap)httpHeaders);
        String url = this.getUrl(request);
        ResponseEntity response = this.getRestTemplate().exchange(url, HttpMethod.GET, requestBody, request.resClass(), new Object[0]);
        log.debug("{}---\u8bf7\u6c42  marketId:{}-------url:{}-------\u8bf7\u6c42\u53c2\u6570\uff1a{}-------\u54cd\u5e94\uff1a{}", new Object[]{this.getLogPrefix(), request.marketId(), url, JSONUtils.objectToJson(request), JSONUtils.objectToJson((Object)response)});
        return (R)((BaseMarketResponse)response.getBody());
    }

    @Override
    public <R extends BaseMarketResponse> R execute(BaseMarketRequest<R> request) throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders();
        this.setToken(httpHeaders, request);
        if (request.formDataPost()) {
            return this.postHttpsForm(request, httpHeaders);
        }
        if (RequestMethod.GET.equals((Object)request.method())) {
            return this.baseGet(request, httpHeaders);
        }
        return this.basePost(request, httpHeaders);
    }

    protected String SHA256(String str) {
        String encdeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(str.getBytes("UTF-8"));
            encdeStr = Hex.encodeHexString((byte[])hash);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return encdeStr;
    }
}

