/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.network.client;

import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.network.client.MarketClient;
import com.jhscale.network.config.NetWorkConfig;
import com.jhscale.network.entity.food.BaseMarketRequest;
import com.jhscale.network.entity.food.BaseMarketResponse;
import com.jhscale.network.entity.food.req.UploadFoodPriceLoginRequest;
import com.jhscale.network.entity.food.res.UploadFoodPriceLoginResponse;
import com.jhscale.network.entity.food.res.UploadFoodTokenInfo;
import com.ysscale.framework.utils.JSONUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestTemplate;

public class UploadFoodPriceClient
implements MarketClient {
    private static final Logger log = LoggerFactory.getLogger(UploadFoodPriceClient.class);
    public static final Integer SUCCESS_CODE = 200;
    private RestTemplate restTemplate;
    private RestTemplate httpsRestTemplate;
    private Map<String, UploadFoodTokenInfo> marketIdAndTokenMap = new HashMap<String, UploadFoodTokenInfo>();
    private Map<String, String> marketIdUsernameMap = new HashMap<String, String>();
    private NetWorkConfig workConfig;

    public UploadFoodPriceClient(NetWorkConfig workConfig) {
        this.workConfig = workConfig;
    }

    @Override
    public <R extends BaseMarketResponse> R execute(BaseMarketRequest<R> request) throws ProfessionalException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Authorization", this.getToken(request.marketId()));
        if (request.formDataPost()) {
            return this.postHttpsForm(request, httpHeaders);
        }
        if (RequestMethod.POST.equals((Object)request.method())) {
            return this.postHttps(request, httpHeaders);
        }
        throw new ProfessionalException(request.method() + "\u6682\u672a\u5b9e\u73b0");
    }

    public boolean isLogin(String marketId) {
        String username = this.marketIdUsernameMap.get(marketId);
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        UploadFoodTokenInfo uploadFoodTokenInfo = this.marketIdAndTokenMap.get(username);
        return Objects.nonNull(uploadFoodTokenInfo) && !uploadFoodTokenInfo.expire();
    }

    private String getToken(String marketId) throws ProfessionalException {
        String username = this.marketIdUsernameMap.get(marketId);
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new ProfessionalException("\u5e02\u573a " + marketId + " \u672a\u767b\u5f55\u6216\u767b\u5f55\u8fc7\u671f");
        }
        UploadFoodTokenInfo uploadFoodTokenInfo = this.marketIdAndTokenMap.get(username);
        if (Objects.isNull(uploadFoodTokenInfo) || uploadFoodTokenInfo.expire()) {
            throw new ProfessionalException("\u5e02\u573a " + marketId + " \u672a\u767b\u5f55\u6216\u767b\u5f55\u8fc7\u671f");
        }
        return uploadFoodTokenInfo.getOriginal();
    }

    public UploadFoodPriceLoginResponse login(UploadFoodPriceLoginRequest request) throws ProfessionalException {
        if (StringUtils.isBlank((CharSequence)request.getUsername()) || StringUtils.isBlank((CharSequence)request.getPassword())) {
            request.setUsername(this.workConfig.getFoodUploadAccount());
            request.setPassword(this.workConfig.getFoodUploadPwd());
        }
        UploadFoodPriceLoginResponse resultBody = null;
        if (this.isLogin(request.getMarketId())) {
            resultBody = new UploadFoodPriceLoginResponse();
            resultBody.setCode(SUCCESS_CODE);
            return resultBody;
        }
        resultBody = this.postHttpsForm(request, null);
        if (Objects.isNull(resultBody) || !SUCCESS_CODE.equals(resultBody.getCode())) {
            log.error("\u4e0a\u6d77\u4e3b\u526f\u98df\u54c1\u8fd0\u884c\u8c03\u63a7\u7cfb\u7edf\u96f6\u552e\u6570\u636e\u5bf9\u63a5---\u8bf7\u6c42\u5931\u8d25  marketId:{}-------url:{}-------\u8bf7\u6c42\u53c2\u6570\uff1a{}-------\u54cd\u5e94\uff1a{}", new Object[]{request.marketId(), request.getUrlPrefix() + request.url(), JSONUtils.objectToJson((Object)request), JSONUtils.objectToJson((Object)resultBody)});
            throw new ProfessionalException("\u767b\u5f55\u5931\u8d25" + (Objects.isNull(resultBody) ? "" : resultBody.getMsg()));
        }
        UploadFoodTokenInfo uploadFoodTokenInfo = resultBody.parseToken();
        this.marketIdUsernameMap.put(request.getMarketId(), request.getUsername());
        this.marketIdAndTokenMap.put(request.getUsername(), uploadFoodTokenInfo);
        return resultBody;
    }

    private RestTemplate getRestTemplate() {
        if (Objects.isNull(this.restTemplate)) {
            this.restTemplate = new RestTemplate();
        }
        return this.restTemplate;
    }

    private RestTemplate getHttpsRestTemplate() {
        if (Objects.isNull(this.httpsRestTemplate)) {
            this.httpsRestTemplate = new RestTemplate();
            SSLContext sslContext = null;
            try {
                sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
            this.httpsRestTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        }
        return this.httpsRestTemplate;
    }

    private <R extends BaseMarketResponse> R postHttpsForm(BaseMarketRequest<R> request, HttpHeaders headers) {
        if (Objects.isNull(headers)) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        BaseMarketRequest<R> realRequest = request.parseRequest();
        if (Objects.isNull(realRequest)) {
            realRequest = request;
        }
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.setAll((Map)JSONUtils.beanToBean(realRequest, HashMap.class));
        HttpEntity requestBody = new HttpEntity((Object)formData, (MultiValueMap)headers);
        String url = request.getUrlPrefix() + request.url();
        ResponseEntity response = this.getHttpsRestTemplate().postForEntity(url, (Object)requestBody, request.resClass(), new Object[0]);
        log.debug("\u4e0a\u6d77\u4e3b\u526f\u98df\u54c1\u8fd0\u884c\u8c03\u63a7\u7cfb\u7edf\u96f6\u552e\u6570\u636e\u5bf9\u63a5---\u8bf7\u6c42  marketId:{}-------url:{}-------\u8bf7\u6c42\u53c2\u6570\uff1a{}-------\u54cd\u5e94\uff1a{}", new Object[]{request.marketId(), url, JSONUtils.objectToJson(request), JSONUtils.objectToJson((Object)response)});
        return (R)((BaseMarketResponse)response.getBody());
    }

    private <R extends BaseMarketResponse> R postHttps(BaseMarketRequest<R> request, HttpHeaders headers) {
        if (Objects.isNull(headers)) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_JSON);
        BaseMarketRequest<R> realRequest = request.parseRequest();
        if (Objects.isNull(realRequest)) {
            realRequest = request;
        }
        HttpEntity requestBody = new HttpEntity(realRequest, (MultiValueMap)headers);
        String url = request.getUrlPrefix() + request.url();
        ResponseEntity response = this.getHttpsRestTemplate().postForEntity(url, (Object)requestBody, request.resClass(), new Object[0]);
        log.debug("\u4e0a\u6d77\u4e3b\u526f\u98df\u54c1\u8fd0\u884c\u8c03\u63a7\u7cfb\u7edf\u96f6\u552e\u6570\u636e\u5bf9\u63a5---\u8bf7\u6c42  marketId:{}-------url:{}-------\u8bf7\u6c42\u53c2\u6570\uff1a{}-------\u54cd\u5e94\uff1a{}", new Object[]{request.marketId(), url, JSONUtils.objectToJson(request), JSONUtils.objectToJson((Object)response)});
        return (R)((BaseMarketResponse)response.getBody());
    }

    private <R extends BaseMarketResponse> R basePost(BaseMarketRequest<R> request, HttpHeaders headers) {
        if (Objects.isNull(headers)) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_JSON);
        BaseMarketRequest<R> realRequest = request.parseRequest();
        if (Objects.isNull(realRequest)) {
            realRequest = request;
        }
        HttpEntity requestBody = new HttpEntity(realRequest, (MultiValueMap)headers);
        String url = request.getUrlPrefix() + request.url();
        ResponseEntity response = this.getRestTemplate().postForEntity(url, (Object)requestBody, request.resClass(), new Object[0]);
        log.debug("\u4e0a\u6d77\u4e3b\u526f\u98df\u54c1\u8fd0\u884c\u8c03\u63a7\u7cfb\u7edf\u96f6\u552e\u6570\u636e\u5bf9\u63a5---\u8bf7\u6c42  marketId:{}-------url:{}-------\u8bf7\u6c42\u53c2\u6570\uff1a{}-------\u54cd\u5e94\uff1a{}", new Object[]{request.marketId(), url, JSONUtils.objectToJson(request), JSONUtils.objectToJson((Object)response)});
        return (R)((BaseMarketResponse)response.getBody());
    }
}

