/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.network.client.impl;

import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.network.client.BaseMarketClient;
import com.jhscale.network.entity.food.BaseMarketRequest;
import com.jhscale.network.entity.food.BaseMarketResponse;
import com.jhscale.network.entity.telecom.req.TelecomLoginRequest;
import com.jhscale.network.entity.telecom.res.TelecomLoginResponse;
import com.jhscale.network.entity.telecom.res.TelecomTokenInfo;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class TelecomServerClient
extends BaseMarketClient<TelecomTokenInfo, TelecomLoginResponse, TelecomLoginRequest> {
    private static final Logger log = LoggerFactory.getLogger(TelecomServerClient.class);
    public static final Integer SUCCESS_CODE = 200;
    private Long EARLY_EXPIRE_MILLIS = 300000L;
    private Map<String, TelecomTokenInfo> idAndTokenMap = new HashMap<String, TelecomTokenInfo>();

    @Override
    public String getLogPrefix() {
        return "\u7535\u4fe1\u76d1\u63a7\u670d\u52a1---";
    }

    @Override
    protected <R extends BaseMarketResponse> void setToken(HttpHeaders httpHeaders, BaseMarketRequest<R> request) throws Exception {
        httpHeaders.set("token", this.getToken(request.marketId()));
    }

    @Override
    protected boolean tokenExpire(TelecomTokenInfo tokenBean) {
        if (Objects.nonNull((Object)tokenBean) && Objects.nonNull(tokenBean.getExpireTime())) {
            long millis;
            Long expireTime = Long.parseLong(tokenBean.getExpireTime());
            return expireTime.compareTo((millis = System.currentTimeMillis()) - this.EARLY_EXPIRE_MILLIS) < 0;
        }
        return true;
    }

    @Override
    public TelecomTokenInfo getTokenBean(String marketId) throws Exception {
        return this.idAndTokenMap.get(marketId);
    }

    @Override
    public String getToken(String marketId) throws Exception {
        TelecomTokenInfo tokenBean = this.getTokenBean(marketId);
        if (Objects.nonNull((Object)tokenBean)) {
            return tokenBean.getAccessToken();
        }
        return null;
    }

    @Override
    protected void saveToken(String mkId, TelecomTokenInfo data) {
        this.idAndTokenMap.put(mkId, data);
    }

    @Override
    public TelecomLoginResponse login(TelecomLoginRequest request) throws Exception {
        String mkId = request.getMarketId();
        String appId = request.getAppId();
        String appKey = request.getAppKey();
        long securityStart = System.currentTimeMillis();
        String transactionId = UUID.randomUUID().toString();
        String sign = null;
        try {
            String key = appId.substring(0, 8) + appKey.substring(appKey.length() - 8);
            String plainText = appId + securityStart;
            byte[] raw = key.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec keySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, keySpec);
            byte[] p = plainText.getBytes(StandardCharsets.UTF_8);
            byte[] result = cipher.doFinal(p);
            sign = Base64.getEncoder().encodeToString(result);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7535\u4fe1\u76d1\u63a7\u670d\u52a1\u767b\u5f55token---\u83b7\u53d6\u7b7e\u540d\u5931\u8d25 mkId: {}  appId:{}   appKey:{}   {}", new Object[]{mkId, appId, appKey, e.getMessage(), e});
            throw new ProfessionalException("\u83b7\u53d6\u7b7e\u540d\u5931\u8d25  mkId: {}" + mkId);
        }
        long securityEnd = System.currentTimeMillis();
        log.debug("   \u83b7\u53d6\u7535\u4fe1\u76d1\u63a7\u670d\u52a1\u767b\u5f55token---mkId: {} \u751f\u6210\u7b7e\u540d---\u8017\u65f6\uff1a{}   appId: {}   appKey: {}   transactionId: {}   sign: {}   ", new Object[]{mkId, securityEnd - securityStart, appId, appKey, transactionId, sign});
        long httpStart = System.currentTimeMillis();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("transactionId", transactionId);
        httpHeaders.set("appKey", this.SHA256(appKey));
        httpHeaders.set("sign", sign);
        TelecomLoginResponse response = this.baseGet(request, httpHeaders);
        long httpEnd = System.currentTimeMillis();
        log.debug("\u83b7\u53d6\u7535\u4fe1\u76d1\u63a7\u670d\u52a1\u767b\u5f55token---mkId: {} ---\u8bf7\u6c42\u7b2c\u4e09\u65b9\u670d\u52a1---\u8017\u65f6\uff1a{}", (Object)mkId, (Object)(httpEnd - httpStart));
        if (Objects.nonNull(response) && SUCCESS_CODE.equals(response.getCode()) && Objects.nonNull(response.getData())) {
            TelecomTokenInfo data = (TelecomTokenInfo)((Object)response.getData());
            this.saveToken(mkId, data);
        }
        return response;
    }
}

