/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.network.service.impl;

import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.HttpUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.network.NetWorkConstant;
import com.jhscale.network.config.NetWorkConfig;
import com.jhscale.network.entity.sh.SHCertJPGJSONRequest;
import com.jhscale.network.entity.sh.SHCertJPGRequest;
import com.jhscale.network.entity.sh.SHCertJPGResponse;
import com.jhscale.network.entity.sh.SHCertQRDecodeRequest;
import com.jhscale.network.entity.sh.SHCertQRDecodeResponse;
import com.jhscale.network.entity.sh.SHCertRequest;
import com.jhscale.network.entity.sh.SHCertResponse;
import com.jhscale.network.entity.sh.SHCertTokenRequest;
import com.jhscale.network.entity.sh.SHCertTokenResponse;
import com.jhscale.network.entity.sh.SHIDObtainRequest;
import com.jhscale.network.entity.sh.SHIDObtainResponse;
import com.jhscale.network.exp.RNetWorkException;
import com.jhscale.network.exp.RNetWorkInternational;
import com.jhscale.network.service.IDCertService;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IDCertServiceImpl
implements IDCertService {
    private static final Logger log = LoggerFactory.getLogger(IDCertServiceImpl.class);
    @Autowired
    private NetWorkConfig netWorkConfig;

    @Override
    public SHIDObtainResponse shanghai(SHIDObtainRequest request) throws ProfessionalException {
        String token = this.token();
        SHCertQRDecodeRequest shCertQRDecodeRequest = new SHCertQRDecodeRequest();
        shCertQRDecodeRequest.setQrCode(request.getQr());
        SHCertQRDecodeResponse shCertQRDecodeResponse = this.obtain("2000101", shCertQRDecodeRequest, request.getAccount(), request.getPassword(), request.getTaskId(), request.getMerchant(), request.getOperator(), token, SHCertQRDecodeResponse.class, RNetWorkInternational.\u4eae\u8bc1\u89e3\u7801\u83b7\u53d6\u5931\u8d25, RNetWorkInternational.\u4eae\u8bc1\u89e3\u7801\u62c6\u5305\u5931\u8d25, RNetWorkInternational.\u4eae\u8bc1\u89e3\u7801\u62c6\u5185\u5305\u5931\u8d25);
        log.debug("SHCertQRDecodeResponse:{}", (Object)shCertQRDecodeResponse.toJSON());
        if (Objects.isNull(request.getType()) || request.getType() == 0) {
            SHCertJPGResponse shCertJPGResponse = this.obtain("3000105", new SHCertJPGRequest(shCertQRDecodeResponse.getCertUuid(), StringUtils.isNotBlank((CharSequence)request.getNumber()) ? request.getNumber() : NetWorkConstant.SH_CERT_DEFAULT_NUMBER, StringUtils.isNotBlank((CharSequence)request.getWatermark()) ? request.getWatermark() : "JHScale"), request.getAccount(), request.getPassword(), request.getTaskId(), request.getMerchant(), request.getOperator(), token, SHCertJPGResponse.class, RNetWorkInternational.\u7535\u5b50\u8425\u4e1a\u6267\u7167\u56fe\u7247\u83b7\u53d6\u5931\u8d25, RNetWorkInternational.\u7535\u5b50\u8425\u4e1a\u6267\u7167\u56fe\u7247\u62c6\u5305\u5931\u8d25, RNetWorkInternational.\u7535\u5b50\u8425\u4e1a\u6267\u7167\u56fe\u7247\u62c6\u5185\u5305\u5931\u8d25);
            log.debug("SHCertJPGResponse:{}", (Object)shCertJPGResponse.toJSON());
            return new SHIDObtainResponse(String.format(this.netWorkConfig.getShCertDownload(), shCertJPGResponse.getThumbnailId(), Objects.isNull(request.getOpen()) || request.getOpen() == 0 ? "inline" : "attachment"));
        }
        List shCertJPGJSONResponse = this.obtain("3000106", new SHCertJPGJSONRequest(shCertQRDecodeResponse.getCertUuid(), StringUtils.isNotBlank((CharSequence)request.getNumber()) ? request.getNumber() : NetWorkConstant.SH_CERT_DEFAULT_NUMBER, StringUtils.isNotBlank((CharSequence)request.getWatermark()) ? request.getWatermark() : "JHScale"), request.getAccount(), request.getPassword(), request.getTaskId(), request.getMerchant(), request.getOperator(), token, List.class, RNetWorkInternational.\u7535\u5b50\u8425\u4e1a\u6267\u7167Base64\u83b7\u53d6\u5931\u8d25, RNetWorkInternational.\u7535\u5b50\u8425\u4e1a\u6267\u7167Base64\u62c6\u5305\u5931\u8d25, RNetWorkInternational.\u7535\u5b50\u8425\u4e1a\u6267\u7167Base64\u62c6\u5185\u5305\u5931\u8d25);
        log.debug("SHCertJPGResponse:{}", (Object)JSONUtils.objectToJSON((Object)shCertJPGJSONResponse));
        return new SHIDObtainResponse(shCertJPGJSONResponse);
    }

    private <T> T obtain(String tradeCode, JSONModel model, String account, String password, String taskId, String merchant, String operator, String token, Class<T> clazz, RNetWorkInternational international1, RNetWorkInternational international2, RNetWorkInternational international3) throws ProfessionalException {
        SHCertRequest request = new SHCertRequest();
        request.defaultTradeToken(StringUtils.isBlank((CharSequence)account) ? this.netWorkConfig.getShCertAccount() : account, StringUtils.isBlank((CharSequence)password) ? this.netWorkConfig.getShCertPassword() : password).addParam(tradeCode, taskId, merchant, operator).addMessage(model);
        log.debug("SHCert Obtain Request:{}", (Object)request.toJSON());
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("Authorization", StringUtils.isNotBlank((CharSequence)token) ? token : this.token());
        String post = HttpUtils.post((String)"http://cert.qpservice.org.cn/cert/certController.do?orgLic", (String)request.toJSON(), head);
        log.debug("SHCert Obtain Response:{}", (Object)post);
        if (StringUtils.isBlank((CharSequence)post)) {
            throw new RNetWorkException(international1);
        }
        SHCertResponse shCertResponse = (SHCertResponse)((Object)JSONUtils.jsonToObject((String)post, SHCertResponse.class));
        if (Objects.isNull((Object)shCertResponse)) {
            throw new RNetWorkException(international2);
        }
        T t = shCertResponse.toInnerBody(clazz);
        if (t == null) {
            throw new RNetWorkException(international3);
        }
        return t;
    }

    private String token() throws RNetWorkException {
        String post = HttpUtils.post((String)"https://e-cert.sheca.com/sdlv3/v3/sdl/api/getToken", (String)new SHCertTokenRequest(this.netWorkConfig.getShCertAppId(), this.netWorkConfig.getShCertAppSecret()).toJSON());
        log.debug("Token Response:{}", (Object)post);
        if (StringUtils.isBlank((CharSequence)post)) {
            throw new RNetWorkException(RNetWorkInternational.Token\u83b7\u53d6\u5931\u8d25);
        }
        SHCertResponse shCertResponse = (SHCertResponse)((Object)JSONUtils.jsonToObject((String)post, SHCertResponse.class));
        if (Objects.isNull((Object)shCertResponse)) {
            throw new RNetWorkException(RNetWorkInternational.Token\u62c6\u5305\u5931\u8d25);
        }
        SHCertTokenResponse response = shCertResponse.toBody(SHCertTokenResponse.class);
        if (response == null || StringUtils.isBlank((CharSequence)response.getToken())) {
            throw new RNetWorkException(RNetWorkInternational.Token\u62c6\u5185\u5305\u5931\u8d25);
        }
        return response.getToken();
    }
}

