/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.network.utils;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class MS2Helper {
    public static final String publicKeyS = "04fe2e8f09df8f7458c72f46ed71ef6d554d8d8595b39fa568dc5f37268ce7bd4fb8208b6e3d6e5515955aae1d4b1b5d1e3a2891def744b53a8436eb285f5a8f30";
    public static final String tradeToken_user = "qptest";
    public static final String tradeToken_pwd = "QPfwzx6189";
    private static X9ECParameters x9ecParameters;
    private static ECParameterSpec ecParameterSpec;
    private static KeyFactory keyFactory;

    public static byte[] encrypt(String publicKeyS, byte[] plainContent) {
        try {
            ECPoint publicKey = x9ecParameters.getCurve().decodePoint(Hex.decodeHex((char[])publicKeyS.toCharArray()));
            BCECPublicKey bcecPublicKey = (BCECPublicKey)keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(publicKey, ecParameterSpec));
            Cipher cipher = Cipher.getInstance("SM2", "BC");
            cipher.init(1, (Key)bcecPublicKey);
            return cipher.doFinal(plainContent);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTradeToken(String tradeToken_user, String tradeToken_pwd) {
        String plainText = tradeToken_user + "#" + tradeToken_pwd + "#" + new Date().getTime();
        byte[] bytes = new byte[]{};
        try {
            bytes = MS2Helper.encrypt(publicKeyS, plainText.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String cipherText = Hex.encodeHexString((byte[])bytes);
        return cipherText;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        x9ecParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ecParameterSpec = new ECParameterSpec(x9ecParameters.getCurve(), x9ecParameters.getG(), x9ecParameters.getN(), x9ecParameters.getH());
        try {
            keyFactory = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

