/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.jraft.rpc.Connection;
import com.alipay.sofa.jraft.rpc.RpcContext;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.rpc.impl.BoltRaftRpcFactory;
import com.alipay.sofa.jraft.rpc.impl.ConnectionClosedEventListener;
import com.alipay.sofa.jraft.util.Requires;

public class BoltRpcServer
implements RpcServer {
    private final com.alipay.remoting.rpc.RpcServer rpcServer;

    public BoltRpcServer(com.alipay.remoting.rpc.RpcServer rpcServer) {
        this.rpcServer = Requires.requireNonNull(rpcServer, "rpcServer");
    }

    @Override
    public boolean init(Void opts) {
        this.rpcServer.switches().turnOn(4);
        this.rpcServer.initWriteBufferWaterMark(BoltRaftRpcFactory.CHANNEL_WRITE_BUF_LOW_WATER_MARK, BoltRaftRpcFactory.CHANNEL_WRITE_BUF_HIGH_WATER_MARK);
        this.rpcServer.startup();
        return this.rpcServer.isStarted();
    }

    @Override
    public void shutdown() {
        this.rpcServer.shutdown();
    }

    @Override
    public void registerConnectionClosedEventListener(ConnectionClosedEventListener listener) {
        this.rpcServer.addConnectionEventProcessor(ConnectionEventType.CLOSE, (remoteAddress, conn) -> {
            Connection proxyConn = conn == null ? null : new Connection(){

                @Override
                public Object getAttribute(String key) {
                    return conn.getAttribute(key);
                }

                @Override
                public void setAttribute(String key, Object value) {
                    conn.setAttribute(key, value);
                }

                @Override
                public void close() {
                    conn.close();
                }
            };
            listener.onClosed(remoteAddress, proxyConn);
        });
    }

    @Override
    public int boundPort() {
        return this.rpcServer.port();
    }

    public void registerProcessor(final RpcProcessor processor) {
        this.rpcServer.registerUserProcessor((UserProcessor)new AsyncUserProcessor<Object>(){

            public void handleRequest(final BizContext bizCtx, final AsyncContext asyncCtx, Object request) {
                RpcContext rpcCtx = new RpcContext(){

                    @Override
                    public void sendResponse(Object responseObj) {
                        asyncCtx.sendResponse(responseObj);
                    }

                    @Override
                    public Connection getConnection() {
                        com.alipay.remoting.Connection conn = bizCtx.getConnection();
                        if (conn == null) {
                            return null;
                        }
                        return new BoltConnection(conn);
                    }

                    @Override
                    public String getRemoteAddress() {
                        return bizCtx.getRemoteAddress();
                    }
                };
                processor.handleRequest(rpcCtx, request);
            }

            public String interest() {
                return processor.interest();
            }

            public UserProcessor.ExecutorSelector getExecutorSelector() {
                RpcProcessor.ExecutorSelector realSelector = processor.executorSelector();
                if (realSelector == null) {
                    return null;
                }
                return realSelector::select;
            }
        });
    }

    public com.alipay.remoting.rpc.RpcServer getServer() {
        return this.rpcServer;
    }

    private static class BoltConnection
    implements Connection {
        private final com.alipay.remoting.Connection conn;

        private BoltConnection(com.alipay.remoting.Connection conn) {
            this.conn = Requires.requireNonNull(conn, "conn");
        }

        @Override
        public Object getAttribute(String key) {
            return this.conn.getAttribute(key);
        }

        @Override
        public void setAttribute(String key, Object value) {
            this.conn.setAttribute(key, value);
        }

        @Override
        public void close() {
            this.conn.close();
        }
    }
}

