/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.consistency.hash;

import com.alipay.sofa.registry.consistency.hash.HashFunction;
import com.alipay.sofa.registry.consistency.hash.HashNode;
import com.alipay.sofa.registry.consistency.hash.MD5HashFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash<T extends HashNode> {
    private static final char SIGN = '#';
    private final int numberOfReplicas;
    private Set<HashNode> realNodes;
    private final HashFunction hashFunction;
    private final SortedMap<Integer, T> circle = new TreeMap<Integer, T>();

    public ConsistentHash(int numberOfReplicas, Collection<T> nodes) {
        this(new MD5HashFunction(), numberOfReplicas, nodes);
    }

    public ConsistentHash(HashFunction hashFunction, int numberOfReplicas, Collection<T> nodes) {
        this.realNodes = new HashSet<HashNode>();
        this.hashFunction = hashFunction;
        this.numberOfReplicas = numberOfReplicas;
        for (HashNode node : nodes) {
            this.addNode(node);
        }
    }

    private void addNode(T node) {
        this.realNodes.add((HashNode)node);
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.put(this.hashFunction.hash(node.getNodeName() + '#' + i), node);
        }
    }

    public T getNodeFor(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hash = this.hashFunction.hash(key);
        HashNode node = (HashNode)this.circle.get(hash);
        if (node == null) {
            SortedMap<Integer, T> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey().intValue() : tailMap.firstKey().intValue();
            node = (HashNode)this.circle.get(hash);
        }
        return (T)node;
    }

    public List<T> getNUniqueNodesFor(Object key, int n) {
        if (this.circle.isEmpty()) {
            return Collections.emptyList();
        }
        if (n > this.realNodes.size()) {
            n = this.realNodes.size();
        }
        ArrayList<HashNode> list = new ArrayList<HashNode>(n);
        int hash = this.hashFunction.hash(key);
        for (int i = 0; i < n; ++i) {
            HashNode candidate;
            if (!this.circle.containsKey(hash)) {
                SortedMap<Integer, T> tailMap = this.circle.tailMap(hash);
                int n2 = hash = tailMap.isEmpty() ? this.circle.firstKey().intValue() : tailMap.firstKey().intValue();
            }
            if (!list.contains(candidate = (HashNode)this.circle.get(hash))) {
                list.add(candidate);
            } else {
                --i;
            }
            ++hash;
        }
        return list;
    }
}

